/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.autoscale.NiftyAutoScaleClient;
import com.nifty.cloud.sdk.autoscale.model.AutoScalingInstancesSet;
import com.nifty.cloud.sdk.autoscale.model.AutoScalingReservationSet;
import com.nifty.cloud.sdk.autoscale.model.DDay;
import com.nifty.cloud.sdk.autoscale.model.Day;
import com.nifty.cloud.sdk.autoscale.model.GroupSet;
import com.nifty.cloud.sdk.autoscale.model.LoadBalancers;
import com.nifty.cloud.sdk.autoscale.model.Month;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.nifty.cloud.sdk.autoscale.model.PlacementSet;
import com.nifty.cloud.sdk.autoscale.model.ScalingSchedule;
import com.nifty.cloud.sdk.autoscale.model.TimeZone;
import com.nifty.cloud.sdk.autoscale.model.TriggerSet;

/**
 * NiftyDescribeAutoScalingGroupsサンプル
 *
 */
public class NiftyDescribeAutoScalingGroupsSample {

    /**
     * NiftyDescribeAutoScalingGroupsを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からオートスケールカテゴリ クライアントを生成します。 非同期実行を行う場合は
         * NiftyAutoScaleAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyAutoScaleClient client = new NiftyAutoScaleClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeAutoScalingGroupsを実行します。
         ***********************************************************************/
        NiftyDescribeAutoScalingGroupsRequest request = new NiftyDescribeAutoScalingGroupsRequest();

        // List<String> list = new ArrayList<String>();
        // list.add("groupName1");
        // list.add("groupName2");

        // request.setAutoScalingGroupName(list);
        invokeNiftyDescribeAutoScalingGroups(client, request);

    }

    /**
     * NiftyDescribeAutoScalingGroups 実行サンプル 設定されたリクエストから NiftyDescribeAutoScalingGroups
     * を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyDescribeAutoScalingGroups(NiftyAutoScaleClient client,
        NiftyDescribeAutoScalingGroupsRequest request) {
        try {

            NiftyDescribeAutoScalingGroupsResult result =
                client.niftyDescribeAutoScalingGroups(request);

            List<AutoScalingReservationSet> list = result.getAutoScalingReservationSet();

            AutoScalingReservationSet set = null;

            List<GroupSet> groupSetList = null;

            GroupSet groupSet = null;

            List<TriggerSet> triggerSetList = null;

            TriggerSet triggerSet = null;

            List<LoadBalancers> loadBalancersList = null;

            LoadBalancers loadBalancers = null;

            List<ScalingSchedule> scalingScheduleList = null;

            ScalingSchedule scalingSchedule = null;

            TimeZone timezone = null;
            Day day = null;
            DDay dDay = null;
            Month month = null;

            List<AutoScalingInstancesSet> autoScalingInstancesSetList = null;
            AutoScalingInstancesSet autoScalingInstancesSet = null;

            out.println("NiftyDescribeAutoScalingGroups Action Response");
            out.println(
                "=============================================================================");

            if (result.getRequestId() != null) {
                out.println("RequestId                 :" + result.getRequestId());
            }

            for (int i = 0; i < list.size(); i++) {

                set = list.get(i);

                if (set.getAutoScalingGroupName() != null) {
                    out.println("  AutoScalingGroupName    :" + set.getAutoScalingGroupName());
                }

                if (set.getDescription() != null) {
                    out.println("  Description             :" + set.getDescription());
                }

                if (set.getImageId() != null) {
                    out.println("  ImageId                 :" + set.getImageId());
                }

                if (set.getInstanceType() != null) {
                    out.println("  InstanceType            :" + set.getInstanceType());
                }

                groupSetList = set.getGroupSet();

                for (int j = 0; j < groupSetList.size(); j++) {

                    groupSet = groupSetList.get(j);

                    if (groupSet.getGroupId() != null) {
                        out.println("    GroupId               :" + groupSet.getGroupId());
                    }

                }

                triggerSetList = set.getTriggerSet();

                for (int j = 0; j < triggerSetList.size(); j++) {

                    triggerSet = triggerSetList.get(j);

                    if (triggerSet.getResource() != null) {
                        out.println("  Resource                :" + triggerSet.getResource());
                    }

                    if (triggerSet.getUpperThreshold() != null) {
                        out.println("  UpperThreshold          :" + triggerSet.getUpperThreshold());
                    }

                    if (triggerSet.getBreachDuration() != null) {
                        out.println("  BreachDuration          :" + triggerSet.getBreachDuration());
                    }

                }

                if (set.getScaleoutCondition() != null) {
                    out.println("  ScaleoutCondition       :" + set.getScaleoutCondition());
                }

                loadBalancersList = set.getLoadBalancers();

                for (int j = 0; j < loadBalancersList.size(); j++) {

                    loadBalancers = loadBalancersList.get(j);

                    if (loadBalancers.getName() != null) {
                        out.println("    LoadBalancerName      :" + loadBalancers.getName());
                    }

                    if (loadBalancers.getLoadBalancerPort() != null) {
                        out.println(
                            "    LoadBalancerPort      :" + loadBalancers.getLoadBalancerPort());
                    }

                    if (loadBalancers.getInstancePort() != null) {
                        out.println(
                            "    InstancePort          :" + loadBalancers.getInstancePort());
                    }

                }

                if (set.getMinSize() != null) {
                    out.println("  MinSize                 :" + set.getMinSize());
                }

                if (set.getMaxSize() != null) {
                    out.println("  MaxSize                 :" + set.getMaxSize());
                }

                if (set.getInstanceLifecycleLimit() != null) {
                    out.println("  InstanceLifecycleLimit  :" + set.getInstanceLifecycleLimit());
                }

                if (set.getScaleout() != null) {
                    out.println("  Scaleout                :" + set.getScaleout());
                }

                if (set.getDefaultCooldown() != null) {
                    out.println("  DefaultCooldown         :" + set.getDefaultCooldown());
                }

                if (set.getChangeInCapacity() != null) {
                    out.println("  ChangeInCapacity        :" + set.getChangeInCapacity());
                }

                scalingScheduleList = set.getScalingSchedule();

                for (int j = 0; j < scalingScheduleList.size(); j++) {

                    scalingSchedule = scalingScheduleList.get(j);

                    timezone = scalingSchedule.getTimeZone();

                    if (timezone.getStartingTimeZone() != null) {
                        out.println("    StartingTimeZone      :" + timezone.getStartingTimeZone());
                    }

                    if (timezone.getEndingTimeZone() != null) {
                        out.println("    EndingTimeZone        :" + timezone.getEndingTimeZone());
                    }

                    day = scalingSchedule.getDay();

                    if (day.getSunday() != null) {
                        out.println("    Sunday                :" + day.getSunday());
                    }

                    if (day.getMonday() != null) {
                        out.println("    Monday                :" + day.getMonday());
                    }

                    if (day.getTuesday() != null) {
                        out.println("    Tuesday               :" + day.getTuesday());
                    }

                    if (day.getWednesday() != null) {
                        out.println("    Wednesday             :" + day.getWednesday());
                    }

                    if (day.getThursday() != null) {
                        out.println("    Thursday              :" + day.getThursday());
                    }

                    if (day.getFriday() != null) {
                        out.println("    Friday                :" + day.getFriday());
                    }

                    if (day.getSaturday() != null) {
                        out.println("    Saturday              :" + day.getSaturday());
                    }

                    dDay = scalingSchedule.getDDay();

                    if (dDay.getStartingDDay() != null) {
                        out.println("    StartingDDay          :" + dDay.getStartingDDay());
                    }

                    if (dDay.getEndingDDay() != null) {
                        out.println("    EndingDDay            :" + dDay.getEndingDDay());
                    }

                    month = scalingSchedule.getMonth();

                    if (month.getStartingMonth() != null) {
                        out.println("    StartingMonth         :" + month.getStartingMonth());
                    }

                    if (month.getEndingMonth() != null) {
                        out.println("    EndingMonth           :" + month.getEndingMonth());
                    }

                }

                PlacementSet placementSet = set.getPlacementSet();

                if (placementSet.getAvailabilityZone() != null) {
                    out.println("      AvailabilityZone    :" + placementSet.getAvailabilityZone());
                }

                autoScalingInstancesSetList = set.getAutoScalingInstancesSet();

                for (int j = 0; j < autoScalingInstancesSetList.size(); j++) {

                    autoScalingInstancesSet = autoScalingInstancesSetList.get(j);

                    if (autoScalingInstancesSet.getInstanceId() != null) {
                        out.println(
                            "    InstanceId            :"
                                + autoScalingInstancesSet.getInstanceId());
                    }

                    if (autoScalingInstancesSet.getInstanceUniqueId() != null) {
                        out.println("    InstanceUniqueId      :"
                            + autoScalingInstancesSet.getInstanceUniqueId());
                    }

                    if (autoScalingInstancesSet.getInstanceState().getCode() != null) {
                        out.println("    Code                  :"
                            + autoScalingInstancesSet.getInstanceState().getCode());
                    }

                    if (autoScalingInstancesSet.getInstanceState().getName() != null) {
                        out.println("    Name                  :"
                            + autoScalingInstancesSet.getInstanceState().getName());
                    }

                    if (autoScalingInstancesSet.getDnsName() != null) {
                        out.println(
                            "    DnsName               :" + autoScalingInstancesSet.getDnsName());
                    }

                    if (autoScalingInstancesSet.getInstanceType() != null) {
                        out.println(
                            "    InstanceType          :"
                                + autoScalingInstancesSet.getInstanceType());
                    }

                    if (autoScalingInstancesSet.getExpireTime() != null) {
                        out.println(
                            "    ExpireTime            :"
                                + autoScalingInstancesSet.getExpireTime());
                    }

                }

                if (set.getCreatedTime() != null) {
                    out.println("  CreatedTime             :" + set.getCreatedTime());
                }

                if (set.getAlarm() != null) {
                    out.println("  Alarm                   :" + set.getAlarm());
                }

            }

            out.println(
                "=============================================================================");

        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
