/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.alarm.NiftyAlarmClient;
import com.nifty.cloud.sdk.alarm.model.AlarmReservationSetDescribe;
import com.nifty.cloud.sdk.alarm.model.AlarmTargetsSet;
import com.nifty.cloud.sdk.alarm.model.EmailAddressSet;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsResult;
import com.nifty.cloud.sdk.alarm.model.RuleSet;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;

/**
 * NiftyDescribeAlarmsサンプル
 *
 */
public class NiftyDescribeAlarmsSample {

    /**
     * NiftyDescribeAlarmsを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報から基本監視カテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyAlarmAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyAlarmClient client = new NiftyAlarmClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeAlarmsを実行します。
         ***********************************************************************/
        NiftyDescribeAlarmsRequest request = new NiftyDescribeAlarmsRequest();
        // List<RuleDescribe> rules = new ArrayList<RuleDescribe>();
        // RuleDescribe rule = new RuleDescribe();
        // rule.setRuleName("ruleName");
        // rule.setFunctionName("functionName");
        // request.setRules(rules);

        invokeNiftyDescribeAlarms(client, request);

    }

    /**
     * NiftyDescribeAlarms 実行サンプル 設定されたリクエストから NiftyDescribeAlarms を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyDescribeAlarms(NiftyAlarmClient client,
        NiftyDescribeAlarmsRequest request) {
        try {
            NiftyDescribeAlarmsResult result = client.niftyDescribeAlarms(request);

            out.println("NiftyDescribeAlarms Action Response");
            out.println(
                "=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId  : " + result.getRequestId());
            }
            if (result.getReservations() != null) {
                List<AlarmReservationSetDescribe> reservations = result.getReservations();
                for (AlarmReservationSetDescribe reservation : reservations) {
                    out.println("ReservationSet");
                    if (reservation.getRuleName() != null) {
                        out.println("  RuleName     : " + reservation.getRuleName());
                    }
                    if (reservation.getDescription() != null) {
                        out.println("  Description     : " + reservation.getDescription());
                    }
                    if (reservation.getAlarmState() != null) {
                        out.println("  AlarmState     : " + reservation.getAlarmState());
                    }
                    if (reservation.getFunctionName() != null) {
                        out.println("  FunctionName     : " + reservation.getFunctionName());
                    }
                    if (reservation.getZone() != null) {
                        out.println("  Zone     : " + reservation.getZone());
                    }
                    if (reservation.getRules() != null) {
                        List<RuleSet> rules = reservation.getRules();
                        for (RuleSet rule : rules) {
                            out.println("  RuleSet");
                            if (rule.getDataType() != null) {
                                out.println("    DataType     : " + rule.getDataType());
                            }
                            if (rule.getThreshold() != null) {
                                out.println("    Threshold     : " + rule.getThreshold());
                            }
                            if (rule.getUpperLowerCondition() != null) {
                                out.println(
                                    "    UpperLowerCondition     : "
                                        + rule.getUpperLowerCondition());
                            }
                            if (rule.getBreachDuration() != null) {
                                out.println("    BreachDuration     : " + rule.getBreachDuration());
                            }
                        }
                    }
                    if (reservation.getAlarmCondition() != null) {
                        out.println("  AlarmCondition     : " + reservation.getAlarmCondition());
                    }
                    if (reservation.getEmailAddresses() != null) {
                        out.println("  EmailAddressSet");
                        List<EmailAddressSet> emailAddresses = reservation.getEmailAddresses();
                        for (EmailAddressSet emailAddress : emailAddresses) {
                            if (emailAddress.getEmailAddress() != null) {
                                out.println(
                                    "    EmailAddress     : " + emailAddress.getEmailAddress());
                            }
                        }
                    }
                    if (reservation.getAlarmTargets() != null) {
                        out.println("  AlarmTagSet");
                        List<AlarmTargetsSet> alarmTargets = reservation.getAlarmTargets();
                        for (AlarmTargetsSet alarmTarget : alarmTargets) {
                            if (alarmTarget.getResourceName() != null) {
                                out.println(
                                    "    ResourceName     : " + alarmTarget.getResourceName());
                            }
                        }
                    }
                    if (reservation.getCreatedTime() != null) {
                        out.println("  CreatedTime     : " + reservation.getCreatedTime());
                    }
                }
            }
            out.println(
                "=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
