/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.alarm.NiftyAlarmClient;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesDateSet;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesEventSet;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesReservationSet;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesSet;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesResult;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;

/**
 * NiftyDescribeAlarmRulesActivitiesサンプル
 *
 */
public class NiftyDescribeAlarmRulesActivitiesSample {

    /**
     * NiftyDescribeAlarmRulesActivitiesを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報から基本監視カテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyAlarmAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyAlarmClient client = new NiftyAlarmClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeAlarmRulesActivitiesを実行します。
         ***********************************************************************/
        NiftyDescribeAlarmRulesActivitiesRequest request =
            new NiftyDescribeAlarmRulesActivitiesRequest();

        // List<RuleActivities> rules = new ArrayList<RuleActivities>();
        // RuleActivities ruleActivities = new RuleActivities();
        // ruleActivities.setRuleName("ruleName");
        // ruleActivities.setFunctionName("functionName");
        // ruleActivities.setDataType("dataType");
        // ruleActivities.setFromDate("fromDate");
        // ruleActivities.setToDate("toDate");
        // request.setRules(rules);

        invokeNiftyDescribeAlarmRulesActivities(client, request);

    }

    /**
     * NiftyDescribeAlarmRulesActivities 実行サンプル 設定されたリクエストから NiftyDescribeAlarmRulesActivities
     * を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyDescribeAlarmRulesActivities(NiftyAlarmClient client,
        NiftyDescribeAlarmRulesActivitiesRequest request) {
        try {
            NiftyDescribeAlarmRulesActivitiesResult result =
                client.niftyDescribeAlarmRulesActivities(request);

            out.println("NiftyDescribeAlarmRulesActivities Action Response");
            out.println(
                "=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId            : " + result.getRequestId());
            }
            if (result.getReservationSets() != null) {
                List<AlarmRulesActivitiesReservationSet> reservationSets =
                    result.getReservationSets();
                for (AlarmRulesActivitiesReservationSet reservationSet : reservationSets) {
                    out.println("ReservationSet");
                    if (reservationSet.getRuleName() != null) {
                        out.println("  RuleName               : " + reservationSet.getRuleName());
                    }
                    if (reservationSet.getFunctionName() != null) {
                        out.println(
                            "  FunctionName           : " + reservationSet.getFunctionName());
                    }
                    if (reservationSet.getAlarmRulesActivitiesSets() != null) {
                        List<AlarmRulesActivitiesSet> alarmRulesActivitiesSets =
                            reservationSet.getAlarmRulesActivitiesSets();
                        for (AlarmRulesActivitiesSet alarmRulesActivitiesSet : alarmRulesActivitiesSets) {
                            out.println("  AlarmRulesActivitiesSet");
                            if (alarmRulesActivitiesSet.getDataType() != null) {
                                out.println("    DataType           : "
                                    + alarmRulesActivitiesSet.getDataType());
                            }
                            if (alarmRulesActivitiesSet.getAlarmRulesActivitiesDateSets() != null) {
                                for (AlarmRulesActivitiesDateSet alarmRulesActivitiesDateSet : alarmRulesActivitiesSet
                                    .getAlarmRulesActivitiesDateSets()) {
                                    out.println("    AlarmRulesActivitiesDateSet");
                                    if (alarmRulesActivitiesDateSet.getDate() != null) {
                                        out.println("      Date                  : "
                                            + alarmRulesActivitiesDateSet.getDate());
                                        if (alarmRulesActivitiesDateSet
                                            .getAlarmRulesActivitiesEvents() != null) {
                                            List<AlarmRulesActivitiesEventSet> alarmRulesActivitiesEventSets =
                                                alarmRulesActivitiesDateSet
                                                    .getAlarmRulesActivitiesEvents();
                                            for (AlarmRulesActivitiesEventSet alarmRulesActivitiesEventSet : alarmRulesActivitiesEventSets) {
                                                out.println("      AlarmRulesActivitiesEventSet");
                                                if (alarmRulesActivitiesEventSet
                                                    .getAlarmRulesActivitiesEventDatetime() != null) {
                                                    out.println(
                                                        "        AlarmRulesActivitiesEventDatetime     : "
                                                            + alarmRulesActivitiesEventSet
                                                                .getAlarmRulesActivitiesEventDatetime());
                                                }
                                                if (alarmRulesActivitiesEventSet
                                                    .getAlarmRulesActivitiesEvent() != null) {
                                                    out.println(
                                                        "        AlarmRulesActivitiesEvent             : "
                                                            + alarmRulesActivitiesEventSet
                                                                .getAlarmRulesActivitiesEvent());
                                                }
                                                if (alarmRulesActivitiesEventSet
                                                    .getResourceName() != null) {
                                                    out.println(
                                                        "        ResourceName                  : "
                                                            + alarmRulesActivitiesEventSet
                                                                .getResourceName());
                                                }
                                                if (alarmRulesActivitiesEventSet
                                                    .getValue() != null) {
                                                    out.println(
                                                        "        Value                         : "
                                                            + alarmRulesActivitiesEventSet
                                                                .getValue());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            out.println(
                "=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
