/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.privatelan.NiftyPrivateLanClient;
import com.nifty.cloud.sdk.privatelan.model.Instance;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.PrivateLan;
import com.nifty.cloud.sdk.privatelan.model.Router;
import com.nifty.cloud.sdk.privatelan.model.Tag;
import com.nifty.cloud.sdk.privatelan.model.VpnGateway;

public class NiftyCreatePrivateLanSample {
	/**
	 * NiftyCreatePrivateLanを実行するサンプルです。
	 * 必要なパラメーターを設定してから利用してください。
	 *
	 * @param args  利用しない
	 */
	public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

		/************************************************************************
		 * 認証情報とクライアント設定情報からサーバーカテゴリ クライアントを生成します。
		 * 非同期実行を行う場合はNiftyPrivateLanClientクラスを指定します。
		 ***********************************************************************/
		NiftyPrivateLanClient client = new NiftyPrivateLanClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        //client.setEndpoint("endpoint_url");

		/************************************************************************
		 * リクエストパラメーターを設定し、NiftyCreatePrivateLanを実行します。
		 ***********************************************************************/
		NiftyCreatePrivateLanRequest request = new NiftyCreatePrivateLanRequest();
		//request.setPrivateLanName("privateLanName");
		//request.setCidrBlock("cidrBlock");
		//request.setAvailabilityZone("availabilityZone");
		//request.setAccountingType("accountingType");
		//request.setDescription("description");
		invokeNiftyCreatePrivateLan(client, request);
	}

	/**
	 * NiftyCreatePrivateLan 実行サンプル
	 * 設定されたリクエストから NiftyCreatePrivateLan を実行し、実行結果を表示します。
	 *
	 * @param client   クライアント
	 * @param request  リクエスト
	 */
	public static void invokeNiftyCreatePrivateLan(NiftyPrivateLanClient client,
			NiftyCreatePrivateLanRequest request) {
		try {
			NiftyCreatePrivateLanResult result = client.niftyCreatePrivateLan(request);

			out.println("NiftyCreatePrivateLan Action Response");
			out.println("=============================================================================");
			if (result.getPrivateLan() != null) {
				PrivateLan privateLans = result.getPrivateLan();
				out.println("PrivateLan");
				if (privateLans.getNetworkId() != null) {
					out.println("  NetworkId              : " + privateLans.getNetworkId());
				}
				if (privateLans.getPrivateLanName() != null) {
					out.println("  PrivateLanName         : " + privateLans.getPrivateLanName());
				}
				if (privateLans.getState() != null) {
					out.println("  State                  : " + privateLans.getState());
				}
				if (privateLans.getCidrBlock() != null) {
					out.println("  CidrBlock              : " + privateLans.getCidrBlock());
				}
				if (privateLans.getAvailabilityZone() != null) {
					out.println("  AvailabilityZone       : " + privateLans.getAvailabilityZone());
				}
				if (privateLans.getTagSets() != null) {
					List<Tag> tagSets = privateLans.getTagSets();
					for (Tag tagSet : tagSets) {
						out.println("  TagSet");
						if (tagSet.getKey() != null) {
							out.println("    Key                  : " + tagSet.getKey());
						}
						if (tagSet.getValue() != null) {
							out.println("    Value                : " + tagSet.getValue());
						}
					}
				}
				if (privateLans.getAccountingType() != null) {
					out.println("  AccountingType         : " + privateLans.getAccountingType());
				}
				if (privateLans.getDescription() != null) {
					out.println("  Description            : " + privateLans.getDescription());
				}
				if (privateLans.getInstanceSets() != null) {
					List<Instance> instancesSets = privateLans.getInstanceSets();
					for (Instance instancesSet    : instancesSets) {
						out.println("  InstanceSet");
						if (instancesSet.getInstanceUniqueId() != null) {
							out.println("    InstanceUniqueId     : " + instancesSet.getInstanceUniqueId());
						}
						if (instancesSet.getInstanceId() != null) {
							out.println("    InstanceId           : " + instancesSet.getInstanceId());
						}
						if (instancesSet.getDeviceIndex() != null) {
							out.println("    DeviceIndex          : " + instancesSet.getDeviceIndex());
						}
						if (instancesSet.getIpAddress() != null) {
							out.println("    IpAddress            : " + instancesSet.getIpAddress());
						}
					}
				}
				if (privateLans.getRouterSets() != null) {
					List<Router> routerSets = privateLans.getRouterSets();
					for (Router routerSet : routerSets) {
						out.println("  RouterSet");
						if (routerSet.getRouterId() != null) {
							out.println("    RouterId             : " + routerSet.getRouterId());
						}
						if (routerSet.getRouterName() != null) {
							out.println("    RouterName           : " + routerSet.getRouterName());
						}
						if (routerSet.getDeviceIndex() != null) {
							out.println("    DeviceIndex          : " + routerSet.getDeviceIndex());
						}
						if (routerSet.getIpAddress() != null) {
							out.println("    IpAddress            : " + routerSet.getIpAddress());
						}
					}
				}
				if (privateLans.getVpnGatewaySets() != null) {
					List<VpnGateway> vpnGatewaySets = privateLans.getVpnGatewaySets();
					for (VpnGateway vpnGatewaySet : vpnGatewaySets) {
						out.println("  VpnGatewaySet");
						if (vpnGatewaySet.getVpnGatewayId() != null) {
							out.println("    VpnGatewayId         : " + vpnGatewaySet.getVpnGatewayId());
						}
						if (vpnGatewaySet.getNiftyVpnGatewayName() != null) {
							out.println("    NiftyVpnGatewayName  : " + vpnGatewaySet.getNiftyVpnGatewayName());
						}
						if (vpnGatewaySet.getDeviceIndex() != null) {
							out.println("    DeviceIndex          : " + vpnGatewaySet.getDeviceIndex());
						}
						if (vpnGatewaySet.getIpAddress() != null) {
							out.println("    IpAddress            : " + vpnGatewaySet.getIpAddress());
						}
					}
				}
				if (privateLans.getCreatedTime() != null) {
					out.println("  CreatedTime            : " + privateLans.getCreatedTime());
				}
				if (privateLans.getSharingStatus() != null) {
					out.println("  SharingStatus          : " + privateLans.getSharingStatus());
				}
			}
			out.println("=============================================================================");
		} catch (NiftyClientException ex) {
			err.println("Message: " + ex.getMessage());
		}
	}
}
