/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.nattable.NiftyNatTableClient;
import com.nifty.cloud.sdk.nattable.model.Destination;
import com.nifty.cloud.sdk.nattable.model.NatRule;
import com.nifty.cloud.sdk.nattable.model.NetworkInterface;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.Source;
import com.nifty.cloud.sdk.nattable.model.Translation;

/**
 * NiftyCreateNatRuleサンプル
 *
 */
public class NiftyCreateNatRuleSample {

    /**
     * NiftyCreateNatRuleを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からNATテーブルカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyNatTableAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyNatTableClient client = new NiftyNatTableClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyCreateNatRuleを実行します。
         ***********************************************************************/
        NiftyCreateNatRuleRequest request = new NiftyCreateNatRuleRequest();
        // NatRule natRule = new NatRule();
        // request.setNatTableId("natTableId");
        // natRule.setNatType("natType");
        // natRule.setRuleNumber("ruleNumber");
        // natRule.setProtocol("protocol");
        // request.setNatRule(natRule);
        invokeNiftyCreateNatRule(client, request);

    }

    /**
     * NiftyCreateNatRule 実行サンプル
     * 設定されたリクエストから NiftyCreateNatRule を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeNiftyCreateNatRule(NiftyNatTableClient client,
            NiftyCreateNatRuleRequest request) {
        try {
            NiftyCreateNatRuleResult result = client.niftyCreateNatRule(request);

            out.println("NiftyCreateNatRule Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId        : " + result.getRequestId());
            }
            if (result.getNatTableId() != null) {
                out.println("NatTableId       : " + result.getNatTableId());
            }
            if (result.getNatRule() != null) {
                NatRule natRule = result.getNatRule();
                out.println("NatRule");
                if (natRule.getNatType() != null) {
                    out.println("  NatType        : " + natRule.getNatType());
                }
                if (natRule.getRuleNumber() != null) {
                    out.println("  RuleNumber     : " + natRule.getRuleNumber());
                }
                if (natRule.getDescription() != null) {
                    out.println("  Description    : " + natRule.getDescription());
                }
                if (natRule.getProtocol() != null) {
                    out.println("  Protocol       : " + natRule.getProtocol());
                }
                if (natRule.getOutboundInterface() != null) {
                    NetworkInterface outboundInterface = natRule.getOutboundInterface();
                    out.println("  OutboundInterface");
                    if (outboundInterface.getNetworkId() != null) {
                        out.println("    NetworkId    : " + outboundInterface.getNetworkId());
                    }
                    if (outboundInterface.getNetworkName() != null) {
                        out.println("    NetworkName  : " + outboundInterface.getNetworkName());
                    }
                }
                if (natRule.getInboundInterface() != null) {
                    NetworkInterface inboundInterface = natRule.getInboundInterface();
                    out.println("  InboundInterface");
                    if (inboundInterface.getNetworkId() != null) {
                        out.println("    NetworkId    : " + inboundInterface.getNetworkId());
                    }

                    if (inboundInterface.getNetworkName() != null) {
                        out.println("    NetworkName  : " + inboundInterface.getNetworkName());
                    }
                }
                if (natRule.getDestination() != null) {
                    Destination destination = natRule.getDestination();
                    out.println("  Destination");
                    if (destination.getPort() != null) {
                        out.println("    Port         : " + destination.getPort());
                    }
                }
                if (natRule.getSource() != null) {
                        Source source = natRule.getSource();
                        out.println("  Source");
                    if (source.getAddress() != null) {
                        out.println("    Address      : " + source.getAddress());
                    }
                    if (source.getPort() != null) {
                        out.println("    Port         : " + source.getPort());
                    }
                }
                if (natRule.getTranslation() != null) {
                    Translation translation = natRule.getTranslation();
                    out.println("  Translation");
                    if (translation.getAddress() != null) {
                        out.println("    Address      : " + translation.getAddress());
                    }
                    if (translation.getPort() != null) {
                        out.println("    Port         : " + translation.getPort());
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
