/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.multiloadbalancer.NiftyMultiLoadBalancerClient;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerResult;

/**
 * NiftyCreateElasticLoadBalancerサンプル
 *
 */
public class NiftyCreateElasticLoadBalancerSample {

    /**
     * NiftyCreateElasticLoadBalancerを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からマルチロードバランサーカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyMultiLoadBalancerAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyMultiLoadBalancerClient client = new NiftyMultiLoadBalancerClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyCreateElasticLoadBalancerを実行します。
         ***********************************************************************/
        NiftyCreateElasticLoadBalancerRequest request =
            new NiftyCreateElasticLoadBalancerRequest();

//        request.setElasticLoadBalancerName("elasticLoadBalancerName");
//        request.setRequestListenerCreate(createRequestListenerCreate());
//        request.setAvailabilityZones(createAvailabilityZones());
//        request.setNetworkVolume(Integer.valueOf(10));
//        request.setAccountingType("1");
//        request.setNetworkInterfaceList(createNetworkInterfaceList());

        invokeNiftyCreateElasticLoadBalancer(client, request);

    }

    /**
     * NiftyCreateElasticLoadBalancer 実行サンプル 設定されたリクエストから NiftyCreateElasticLoadBalancer
     * を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyCreateElasticLoadBalancer(
        NiftyMultiLoadBalancerClient client,
        NiftyCreateElasticLoadBalancerRequest request) {
        try {
            NiftyCreateElasticLoadBalancerResult result =
                client.niftyCreateElasticLoadBalancer(request);

            out.println("NiftyCreateElasticLoadBalancer Action Response");
            out.println(
                "=============================================================================");

            if (result.getDnsName() != null) {
                out.println("DnsName            :" + result.getDnsName());
            }

            out.println(
                "=============================================================================");

        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
/*
    private static RequestListenerCreate createRequestListenerCreate() {

        List<RequestListenerCreateMember> memberList = new ArrayList<RequestListenerCreateMember>();

        memberList.add(createRequestListenerCreateMember());
        memberList.add(createRequestListenerCreateMember());

        RequestListenerCreate create = new RequestListenerCreate();

        create.setMemberList(memberList);

        return create;
    }
*/
/*
    private static RequestListenerCreateMember createRequestListenerCreateMember() {

        RequestListenerCreateMember member = new RequestListenerCreateMember();

        member.setProtocol("https");
        member.setElasticLoadBalancerPort(Integer.valueOf(8081));
        member.setInstancePort(Integer.valueOf(8082));
        member.setBalancingType("1");
        member.setDescription("description");
        member.setInstances(createInstance());
        member.setHealthCheck(createHealthCheck());
        member.setSslCertificateId("sslCertificateId");
        member.setSession(createSession());
        member.setSorryPage(createSorryPage());

        return member;
    }
*/
/*
    private static AvailabilityZones createAvailabilityZones() {

        AvailabilityZones availabilityZones = new AvailabilityZones();

        List<String> availabilityZonesMemberList = new ArrayList<String>();
        availabilityZonesMemberList.add("zone");

        availabilityZones.setMember(availabilityZonesMemberList);

        return availabilityZones;
    }
*/
/*
    private static List<NetworkInterface> createNetworkInterfaceList() {

        List<NetworkInterface> networkInterfaceList = new ArrayList<NetworkInterface>();

        NetworkInterface networkInterface1 = new NetworkInterface();
        networkInterface1.setNetworkId("networkId1");
        networkInterface1.setNetworkName("networkName1");
        networkInterface1.setIpAddress("ipAddress1");
        networkInterface1.setIsVipNetwork(Boolean.FALSE);

        List<SystemIpAddress> systemIpAddressList = new ArrayList<SystemIpAddress>();
        systemIpAddressList.add(new SystemIpAddress().withSystemIpAddress("systemIpAddress1"));
        systemIpAddressList.add(new SystemIpAddress().withSystemIpAddress("systemIpAddress2"));
        networkInterface1.setSystemIpAddresses(systemIpAddressList);

        networkInterfaceList.add(networkInterface1);

        NetworkInterface networkInterface2 = new NetworkInterface();
        networkInterface2.setNetworkId("networkId2");
        networkInterface2.setNetworkName("networkName2");
        networkInterface2.setIpAddress("ipAddress2");
        networkInterface2.setIsVipNetwork(Boolean.TRUE);

        networkInterfaceList.add(networkInterface2);

        return networkInterfaceList;
    }
*/
/*
    private static Instance createInstance() {

        Instance instance = new Instance();

        List<ServerMember> serverMemberList = new ArrayList<ServerMember>();

        ServerMember serverMember1 = new ServerMember();
        serverMember1.setInstanceUniqueId("instanceUniqueId1");
        serverMember1.setInstanceId("instanceId1");

        serverMemberList.add(serverMember1);

        ServerMember serverMember2 = new ServerMember();
        serverMember2.setInstanceUniqueId("instanceUniqueId2");
        serverMember2.setInstanceId("instanceId2");

        serverMemberList.add(serverMember2);

        instance.setMemberList(serverMemberList);

        return instance;
    }
*/
/*
    private static HealthCheck createHealthCheck() {

        HealthCheck check = new HealthCheck();

        check.setTarget("target");
        check.setInterval(Integer.valueOf(20));
        check.setUnhealthyThreshold(Integer.valueOf(5));
        check.setPath("path");

        Expectation expectation = new Expectation();

        List<ExpectationMember> memberList = new ArrayList<ExpectationMember>();

        ExpectationMember member1 = new ExpectationMember();
        member1.setHttpCode("1xx");

        memberList.add(member1);

        ExpectationMember member2 = new ExpectationMember();
        member2.setHttpCode("2xx");

        memberList.add(member2);

        expectation.setMemberList(memberList);

        check.setExpectation(expectation);

        return check;

    }
*/
/*
    private static Session createSession() {

        Session session = new Session();

        StickinessPolicy stickinessPolicy = new StickinessPolicy();
        stickinessPolicy.setEnable(Boolean.TRUE);
        stickinessPolicy.setMethod("method");
        stickinessPolicy.setExpirationPeriod(Integer.valueOf(5));

        session.setStickinessPolicy(stickinessPolicy);

        return session;
    }
*/
/*
    private static SorryPage createSorryPage() {

        SorryPage sorryPage = new SorryPage();

        sorryPage.setEnable(Boolean.TRUE);
        sorryPage.setRedirectUrl("testUrl");

        return sorryPage;
    }
*/
}
