/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayClient;
import com.nifty.cloud.sdk.vpngateway.model.Attachment;
import com.nifty.cloud.sdk.vpngateway.model.BackupInformation;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NetworkInterfaceSet;
import com.nifty.cloud.sdk.vpngateway.model.Tag;
import com.nifty.cloud.sdk.vpngateway.model.VersionInformation;
import com.nifty.cloud.sdk.vpngateway.model.VpnGateway;

/**
 * DescribeVpnGatewaysサンプル
 *
 */
public class DescribeVpnGatewaysSample {

    /**
     * DescribeVpnGatewaysを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からVPNゲートウェイカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyVpnGatewayAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyVpnGatewayClient client = new NiftyVpnGatewayClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、DescribeVpnGatewaysを実行します。
         ***********************************************************************/
        DescribeVpnGatewaysRequest request = new DescribeVpnGatewaysRequest();
        invokeDescribeVpnGateways(client, request);

    }

    /**
     * DescribeVpnGateways 実行サンプル
     * 設定されたリクエストから DescribeVpnGateways を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeDescribeVpnGateways(NiftyVpnGatewayClient client,
            DescribeVpnGatewaysRequest request) {
        try {
            DescribeVpnGatewaysResult result = client.describeVpnGateways(request);

            out.println("DescribeVpnGateways Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId                     : " + result.getRequestId());
            }
            if (result.getVpnGateways() != null) {
                List<VpnGateway> vpnGateways = result.getVpnGateways();
                for (VpnGateway vpnGateway : vpnGateways) {
                    out.println("VpnGatewaySet");
                    if (vpnGateway.getVpnGatewayId() != null) {
                        out.println("  VpnGatewayId                : " + vpnGateway.getVpnGatewayId());
                    }
                    if (vpnGateway.getNiftyVpnGatewayName() != null) {
                        out.println("  NiftyVpnGatewayName         : " + vpnGateway.getNiftyVpnGatewayName());
                    }
                    if (vpnGateway.getState() != null) {
                        out.println("  State                       : " + vpnGateway.getState());
                    }
                    if (vpnGateway.getType() != null) {
                        out.println("  Type                        : " + vpnGateway.getType());
                    }
                    if (vpnGateway.getAvailabilityZone() != null) {
                        out.println("  AvailabilityZone            : " + vpnGateway.getAvailabilityZone());
                    }
                    if (vpnGateway.getAttachments() != null) {
                        List<Attachment> attachments = vpnGateway.getAttachments();
                        for (Attachment attachment : attachments) {
                            out.println("  Attachments");
                            if (attachment.getVpcId() != null) {
                                out.println("    VpcId                     : " + attachment.getVpcId());
                            }
                            if (attachment.getState() != null) {
                                out.println("    State                     : " + attachment.getState());
                            }
                        }
                    }
                    if (vpnGateway.getTagSet() != null) {
                        List<Tag> tagSet = vpnGateway.getTagSet();
                        for (Tag tag : tagSet) {
                            out.println("  TagSet");
                            if (tag.getKey() != null) {
                                out.println("    Key                       : " + tag.getKey());
                            }
                            if (tag.getValue() != null) {
                                out.println("    Value                     : " + tag.getValue());
                            }
                        }
                    }
                    if (vpnGateway.getNiftyVpnGatewayType() != null) {
                        out.println("  NiftyVpnGatewayType         : " + vpnGateway.getNiftyVpnGatewayType());
                    }
                    if (vpnGateway.getNiftyRedundancy() != null) {
                        out.println("  NiftyRedundancy             : " + vpnGateway.getNiftyRedundancy());
                    }
                    if (vpnGateway.getNiftyVpnGatewayDescription() != null) {
                        out.println("  NiftyVpnGatewayDescription  : " + vpnGateway.getNiftyVpnGatewayDescription());
                    }
                    if (vpnGateway.getAccountingType() != null) {
                        out.println("  AccountingType              : " + vpnGateway.getAccountingType());
                    }
                    if (vpnGateway.getNextMonthAccountingType() != null) {
                        out.println("  NextMonthAccountingType     : " + vpnGateway.getNextMonthAccountingType());
                    }
                    if (vpnGateway.getVersionInformation() != null) {
                        VersionInformation versionInformation = vpnGateway.getVersionInformation();
                        out.println("  VersionInformation");
                        if (versionInformation.getIsLatest() != null) {
                            out.println("    IsLatest                  : " + versionInformation.getIsLatest());
                        }
                        if (versionInformation.getVersion() != null) {
                            out.println("    Version                   : " + versionInformation.getVersion());
                        }
                    }
                    if (vpnGateway.getNetworkInterfaces() != null) {
                        List<NetworkInterfaceSet> networkInterfaces = vpnGateway.getNetworkInterfaces();
                        for (NetworkInterfaceSet networkInterface : networkInterfaces) {
                            out.println("  NetworkInterfaces");
                            if (networkInterface.getNetworkId() != null) {
                                out.println("    NetworkId                 : " + networkInterface.getNetworkId());
                            }
                            if (networkInterface.getNetworkName() != null) {
                                out.println("    NetworkName               : " + networkInterface.getNetworkName());
                            }
                            if (networkInterface.getDeviceIndex() != null) {
                                out.println("    DeviceIndex               : " + networkInterface.getDeviceIndex());
                            }
                            if (networkInterface.getIpAddress() != null) {
                                out.println("    IpAddress                 : " + networkInterface.getIpAddress());
                            }
                            if (networkInterface.getCidrBlock() != null) {
                                out.println("    CidrBlock                 : " + networkInterface.getCidrBlock());
                            }
                            if (networkInterface.getDescription() != null) {
                                out.println("    Description               : " + networkInterface.getDescription());
                            }
                        }
                    }
                    if (vpnGateway.getBackupInformation() != null) {
                        BackupInformation backupInformation = vpnGateway.getBackupInformation();
                        out.println("  BackupInformation");
                        if (backupInformation.getIsBackup() != null) {
                            out.println("    IsBackup                  : " + backupInformation.getIsBackup());
                        }
                        if (backupInformation.getExpirationDate() != null) {
                            out.println("    ExpirationDate            : " + backupInformation.getExpirationDate());
                        }
                    }
                    if (vpnGateway.getGroupIds() != null) {
                        List<String> groupIds = vpnGateway.getGroupIds();
                        for (String groupId : groupIds) {
                            out.println("  GroupIds");
                            out.println("    GroupId                   : " + groupId);
                        }
                    }
                    if (vpnGateway.getRouteTableId() != null) {
                        out.println("  RouteTableId                : " + vpnGateway.getRouteTableId());
                    }
                    if (vpnGateway.getRouteTableAssociationId() != null) {
                        out.println("  RouteTableAssociationId     : " + vpnGateway.getRouteTableAssociationId());
                    }
                    if (vpnGateway.getCreatedTime() != null) {
                        out.println("  CreatedTime                 : " + vpnGateway.getCreatedTime());
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
