/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.vpnconnection.NiftyVpnConnectionClient;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsResult;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyIpsecConfiguration;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyTunnel;
import com.nifty.cloud.sdk.vpnconnection.model.Tag;
import com.nifty.cloud.sdk.vpnconnection.model.VgwTelemetry;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnection;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnectionOptions;
import com.nifty.cloud.sdk.vpnconnection.model.VpnStaticRoutes;

/**
 * DescribeVpnConnectionsサンプル
 *
 */
public class DescribeVpnConnectionsSample {

    /**
     * DescribeVpnConnectionsを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からVPNコネクションカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyVpnConnectionAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyVpnConnectionClient client = new NiftyVpnConnectionClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、DescribeVpnConnectionsを実行します。
         ***********************************************************************/
        DescribeVpnConnectionsRequest request = new DescribeVpnConnectionsRequest();
        invokeDescribeVpnConnections(client, request);

    }

    /**
     * DescribeVpnConnections 実行サンプル
     * 設定されたリクエストから DescribeVpnConnections を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeDescribeVpnConnections(NiftyVpnConnectionClient client,
            DescribeVpnConnectionsRequest request) {
        try {
            DescribeVpnConnectionsResult result = client.describeVpnConnections(request);

            out.println("DescribeVpnConnections Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId                       : " + result.getRequestId());
            }
            if (result.getVpnConnections() != null) {
                List<VpnConnection> vpnConnections = result.getVpnConnections();
                for (VpnConnection vpnConnection : vpnConnections) {
                    out.println("VpnConnectionSet");
                    if (vpnConnection.getVpnConnectionId() != null) {
                        out.println("  VpnConnectionId               : " + vpnConnection.getVpnConnectionId());
                    }
                    if (vpnConnection.getState() != null) {
                        out.println("  State                         : " + vpnConnection.getState());
                    }
                    if (vpnConnection.getCustomerGatewayConfiguration() != null) {
                        out.println("  CustomerGatewayConfiguration  : " + vpnConnection.getCustomerGatewayConfiguration());
                    }
                    if (vpnConnection.getType() != null) {
                        out.println("  Type                          : " + vpnConnection.getType());
                    }
                    if (vpnConnection.getVpnGatewayId() != null) {
                        out.println("  VpnGatewayId                  : " + vpnConnection.getVpnGatewayId());
                    }
                    if (vpnConnection.getNiftyVpnGatewayName() != null) {
                        out.println("  NiftyVpnGatewayName           : " + vpnConnection.getNiftyVpnGatewayName());
                    }
                    if (vpnConnection.getCustomerGatewayId() != null) {
                        out.println("  CustomerGatewayId             : " + vpnConnection.getCustomerGatewayId());
                    }
                    if (vpnConnection.getNiftyCustomerGatewayName() != null) {
                        out.println("  NiftyCustomerGatewayName      : " + vpnConnection.getNiftyCustomerGatewayName());
                    }
                    if (vpnConnection.getTagSet() != null) {
                        List<Tag> tagSet = vpnConnection.getTagSet();
                        for (Tag tag : tagSet) {
                            out.println("  TagSet");
                            if (tag.getKey() != null) {
                                out.println("    Key                         : " + tag.getKey());
                            }
                            if (tag.getValue() != null) {
                                out.println("    Value                       : " + tag.getValue());
                            }
                        }
                    }
                    if (vpnConnection.getVgwTelemetries() != null) {
                        List<VgwTelemetry> vgwTelemetries = vpnConnection.getVgwTelemetries();
                        for (VgwTelemetry vgwTelemetry : vgwTelemetries) {
                            out.println("  VgwTelemetry");
                            if (vgwTelemetry.getOutsideIpAddress() != null) {
                                out.println("    OutsideIpAddress            : " + vgwTelemetry.getOutsideIpAddress());
                            }
                            if (vgwTelemetry.getStatus() != null) {
                                out.println("    Status                      : " + vgwTelemetry.getStatus());
                            }
                            if (vgwTelemetry.getLastStatusChange() != null) {
                                out.println("    LastStatusChange            : " + vgwTelemetry.getLastStatusChange());
                            }
                            if (vgwTelemetry.getStatusMessage() != null) {
                                out.println("    StatusMessage               : " + vgwTelemetry.getStatusMessage());
                            }
                            if (vgwTelemetry.getAcceptedRouteCount() != null) {
                                out.println("    AcceptedRouteCount          : " + vgwTelemetry.getAcceptedRouteCount());
                            }
                        }
                    }
                    if (vpnConnection.getOptions() != null) {
                        VpnConnectionOptions options = vpnConnection.getOptions();
                        out.println("  Options");
                        if (options.getStaticRoutesOnly() != null) {
                            out.println("    StaticRoutesOnly            : " + options.getStaticRoutesOnly());
                        }
                    }
                    if (vpnConnection.getRoutes() != null) {
                        VpnStaticRoutes routes = vpnConnection.getRoutes();
                        out.println("  Routes");
                        if (routes.getDestinationCidrBlock() != null) {
                            out.println("    DestinationCidrBlock        : " + routes.getDestinationCidrBlock());
                        }
                        if (routes.getSource() != null) {
                            out.println("    Source                      : " + routes.getSource());
                        }
                        if (routes.getState() != null) {
                            out.println("    State                       : " + routes.getState());
                        }
                    }
                    if (vpnConnection.getNiftyVpnConnectionDescription() != null) {
                        out.println("  NiftyVpnConnectionDescription : " + vpnConnection.getNiftyVpnConnectionDescription());
                    }
                    if (vpnConnection.getCreatedTime() != null) {
                        out.println("  CreatedTime                   : " + vpnConnection.getCreatedTime());
                    }
                    if (vpnConnection.getNiftyTunnel() != null) {
                        NiftyTunnel niftyTunnel = vpnConnection.getNiftyTunnel();
                        out.println("  NiftyTunnel");
                        if (niftyTunnel.getType() != null) {
                            out.println("    Type                        : " + niftyTunnel.getType());
                        }
                        if (niftyTunnel.getMode() != null) {
                            out.println("    Mode                        : " + niftyTunnel.getMode());
                        }
                        if (niftyTunnel.getEncapsulation() != null) {
                            out.println("    Encapsulation               : " + niftyTunnel.getEncapsulation());
                        }
                        if (niftyTunnel.getTunnelId() != null) {
                            out.println("    TunnelId                    : " + niftyTunnel.getTunnelId());
                        }
                        if (niftyTunnel.getPeerTunnelId() != null) {
                            out.println("    PeerTunnelId                : " + niftyTunnel.getPeerTunnelId());
                        }
                        if (niftyTunnel.getSessionId() != null) {
                            out.println("    SessionId                   : " + niftyTunnel.getSessionId());
                        }
                        if (niftyTunnel.getPeerSessionId() != null) {
                            out.println("    PeerSessionId               : " + niftyTunnel.getPeerSessionId());
                        }
                        if (niftyTunnel.getSourcePort() != null) {
                            out.println("    SourcePort                  : " + niftyTunnel.getSourcePort());
                        }
                        if (niftyTunnel.getDestinationPort() != null) {
                            out.println("    DestinationPort             : " + niftyTunnel.getDestinationPort());
                        }
                    }
                    if (vpnConnection.getNiftyIpsecConfiguration() != null) {
                        NiftyIpsecConfiguration niftyIpsecConfiguration = vpnConnection.getNiftyIpsecConfiguration();
                        out.println("  NiftyIpsecConfiguration");
                        if (niftyIpsecConfiguration.getEncryptionAlgorithm() != null) {
                            out.println("    EncryptionAlgorithm         : " + niftyIpsecConfiguration.getEncryptionAlgorithm());
                        }
                        if (niftyIpsecConfiguration.getHashingAlgorithm() != null) {
                            out.println("    HashingAlgorithm            : " + niftyIpsecConfiguration.getHashingAlgorithm());
                        }
                        if (niftyIpsecConfiguration.getMtu() != null) {
                            out.println("    Mtu                         : " + niftyIpsecConfiguration.getMtu());
                        }
                        if (niftyIpsecConfiguration.getPreSharedKey() != null) {
                            out.println("    PreSharedKey                : " + niftyIpsecConfiguration.getPreSharedKey());
                        }
                        if (niftyIpsecConfiguration.getInternetKeyExchange() != null) {
                            out.println("    InternetKeyExchange         : " + niftyIpsecConfiguration.getInternetKeyExchange());
                        }
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
