/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.routetable.NiftyRouteTableClient;
import com.nifty.cloud.sdk.routetable.model.*;

/**
 * DescribeRouteTablesサンプル
 *
 */
public class DescribeRouteTablesSample {

    /**
     * DescribeRouteTablesを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からルートテーブルカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyRouteTableAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyRouteTableClient client = new NiftyRouteTableClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、DescribeRouteTablesを実行します。
         ***********************************************************************/
        DescribeRouteTablesRequest request = new DescribeRouteTablesRequest();
        invokeDescribeRouteTables(client, request);

    }

    /**
     * DescribeRouteTables 実行サンプル
     * 設定されたリクエストから DescribeRouteTables を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeDescribeRouteTables(NiftyRouteTableClient client,
            DescribeRouteTablesRequest request) {
        try {
            DescribeRouteTablesResult result = client.describeRouteTables(request);

            out.println("DescribeRouteTables Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId                    : " + result.getRequestId());
            }
            if (result.getRouteTables() != null) {
                List<RouteTableSet> routeTables = result.getRouteTables();
                for (RouteTableSet routeTable : routeTables) {
                    out.println("RouteTableSet");
                    if (routeTable.getRouteTableId() != null) {
                        out.println("  RouteTableId               : " + routeTable.getRouteTableId());
                    }
                    if (routeTable.getVpcId() != null) {
                        out.println("  VpcId                      : " + routeTable.getVpcId());
                    }
                    if (routeTable.getRoutes() != null) {
                        List<Route> routes = routeTable.getRoutes();
                        for (Route route : routes) {
                            out.println("  RouteSet");
                            if (route.getDestinationCidrBlock() != null) {
                                out.println("    DestinationCidrBlock     : " + route.getDestinationCidrBlock());
                            }
                            if (route.getGatewayId() != null) {
                                out.println("    GatewayId                : " + route.getGatewayId());
                            }
                            if (route.getInstanceId() != null) {
                                out.println("    InstanceId               : " + route.getInstanceId());
                            }
                            if (route.getInstanceOwnerId() != null) {
                                out.println("    InstanceOwnerId          : " + route.getInstanceOwnerId());
                            }
                            if (route.getNetworkInterfaceId() != null) {
                                out.println("    NetworkInterfaceId       : " + route.getNetworkInterfaceId());
                            }
                            if (route.getIpAddress() != null) {
                                out.println("    IpAddress                : " + route.getIpAddress());
                            }
                            if (route.getNetworkId() != null) {
                                out.println("    NetworkId                : " + route.getNetworkId());
                            }
                            if (route.getNetworkName() != null) {
                                out.println("    NetworkName              : " + route.getNetworkName());
                            }
                            if (route.getState() != null) {
                                out.println("    State                    : " + route.getState());
                            }
                            if (route.getOrigin() != null) {
                                out.println("    Origin                   : " + route.getOrigin());
                            }
                            if (route.getPriority() != null) {
                                out.println("    Priority                 : " + route.getPriority());
                            }
                            if (route.getVpcPeeringConnectionId() != null) {
                                out.println("    VpcPeeringConnectionId   : " + route.getVpcPeeringConnectionId());
                            }
                        }
                    }
                    if (routeTable.getAssociations() != null) {
                        List<RouteTableAssociation> associations = routeTable.getAssociations();
                        for (RouteTableAssociation association : associations) {
                            out.println("  AssociationSet");
                            if (association.getRouteTableAssociationId() != null) {
                                out.println("    RouteTableAssociationId  : " + association.getRouteTableAssociationId());
                            }
                            if (association.getRouteTableId() != null) {
                                out.println("    RouteTableId             : " + association.getRouteTableId());
                            }
                            if (association.getSubnetId() != null) {
                                out.println("    SubnetId                 : " + association.getSubnetId());
                            }
                            if (association.getMain() != null) {
                                out.println("    Main                     : " + association.getMain());
                            }
                            if (association.getRouterId() != null) {
                                out.println("    RouterId                 : " + association.getRouterId());
                            }
                            if (association.getRouterName() != null) {
                                out.println("    RouterName               : " + association.getRouterName());
                            }
                        }
                    }
                    if (routeTable.getPropagatingVgws() != null) {
                        List<PropagatingVgw> propagatingVgws = routeTable.getPropagatingVgws();
                        for (PropagatingVgw propagatingVgw : propagatingVgws) {
                            out.println("  PropagatingVgwSet");
                            if (propagatingVgw.getGatewayId() != null) {
                                out.println("    GatewayId                : " + propagatingVgw.getGatewayId());
                            }
                            if (propagatingVgw.getNiftyGatewayName() != null) {
                                out.println("    NiftyGatewayName         : " + propagatingVgw.getNiftyGatewayName());
                            }
                            if (propagatingVgw.getRouteTableAssociationId() != null) {
                                out.println("    RouteTableAssociationId  : " + propagatingVgw.getRouteTableAssociationId());
                            }
                        }
                    }
                    if (routeTable.getTagSet() != null) {
                        List<Tag> tagSet = routeTable.getTagSet();
                        for (Tag tag : tagSet) {
                            out.println("  TagSet");
                            if (tag.getKey() != null) {
                                out.println("    Key                      : " + tag.getKey());
                            }
                            if (tag.getValue() != null) {
                                out.println("    Value                    : " + tag.getValue());
                            }
                        }
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
