/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.dashboard.NiftyDashboardClient;
import com.nifty.cloud.sdk.dashboard.model.DescribeResourcesRequest;
import com.nifty.cloud.sdk.dashboard.model.DescribeResourcesResult;
import com.nifty.cloud.sdk.dashboard.model.ResourceElasticIp;
import com.nifty.cloud.sdk.dashboard.model.ResourceInstance;
import com.nifty.cloud.sdk.dashboard.model.ResourceNetworkInterface;
import com.nifty.cloud.sdk.dashboard.model.ResourceRouter;
import com.nifty.cloud.sdk.dashboard.model.ResourceVpnGateway;
import com.nifty.cloud.sdk.dashboard.model.Resources;

/**
 * DescribeResourcesサンプル
 *
 */
public class DescribeResourcesSample {

    /**
     * DescribeResourcesを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args 利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *   - HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からダッシュボードカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyDashboardAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyDashboardClient client = new NiftyDashboardClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、DescribeResourcesを実行します。
         ***********************************************************************/
        DescribeResourcesRequest request = new DescribeResourcesRequest();

        invokeDescribeResources(client, request);
    }

    /**
     * DescribeResources 実行サンプル
     * 設定されたリクエストから DescribeResources を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeDescribeResources(NiftyDashboardClient client,
            DescribeResourcesRequest request) {
        try {
            DescribeResourcesResult result = client.describeResources(request);

            out.println("DescribeResources Action Response");
            out.println("=============================================================================");

            Resources resource = result.getResource();

            if (resource.getInstances() != null) {
                out.println("Instances");
                List<ResourceInstance> instances = resource.getInstances();
                for (ResourceInstance instance :instances) {
                    if (instance.getType() != null) {
                        out.println("  Type                  : " + instance.getType());
                    }
                    if (instance.getCount() != null) {
                        out.println("  Count                 : " + instance.getCount());
                        }
                    }
            }
            if (resource.getDynamicIpCount() != null) {
                out.println("DynamicIpCount          : " + resource.getDynamicIpCount());
            }
            if (resource.getCustomizeImageCount() != null) {
                out.println("CustomizeImageCount     : " + resource.getCustomizeImageCount());
            }
            if (resource.getAddDiskCount() != null) {
                out.println("AddDiskCount            : " + resource.getAddDiskCount());
            }
            if (resource.getAddDiskTotalSize() != null) {
                out.println("AddDiskTotalSize        : " + resource.getAddDiskTotalSize());
            }
            if (resource.getRouters() != null) {
                out.println("Routers");
                List<ResourceRouter> routers = resource.getRouters();
                for (ResourceRouter router :routers) {
                    if (router.getType() != null) {
                        out.println("  Type                  : " + router.getType());
                    }
                    if (router.getCount() != null) {
                        out.println("  Count                 : " + router.getCount());
                        }
                    }
            }
            if (resource.getVpnGateways() != null) {
                out.println("VpnGateways");
                List<ResourceVpnGateway> vpnGateways = resource.getVpnGateways();
                for (ResourceVpnGateway vpnGateway :vpnGateways) {
                    if (vpnGateway.getType() != null) {
                        out.println("  Type                  : " + vpnGateway.getType());
                    }
                    if (vpnGateway.getCount() != null) {
                        out.println("  Count                 : " + vpnGateway.getCount());
                        }
                    }
            }
            if (resource.getNetworkFlowAmount() != null) {
                out.println("NetworkFlowAmount       : " + resource.getNetworkFlowAmount());
            }
            if (resource.getSecurityGroupCount() != null) {
                out.println("SecurityGroupCount      : " + resource.getSecurityGroupCount());
            }
            if (resource.getLoadBalancerCount() != null) {
                out.println("LoadBalancerCount       : " + resource.getLoadBalancerCount());
            }
            if (resource.getElasticIps() != null) {
                out.println("ElasticIps");
                List<ResourceElasticIp> elasticIps = resource.getElasticIps();
                for (ResourceElasticIp elasticIp : elasticIps) {
                    if (elasticIp.getType() != null) {
                        out.println("  Type                  : " + elasticIp.getType());
                    }
                    if (elasticIp.getCount() != null) {
                        out.println("  Count                 : " + elasticIp.getCount());
                    }
                }
            }
            if (resource.getSslCertCount() != null) {
                out.println("SslCertCount            : " + resource.getSslCertCount());
            }
            if (resource.getMonitoringRuleCount() != null) {
                out.println("MonitoringRuleCount     : " + resource.getMonitoringRuleCount());
            }
            if (resource.getAutoScaleCount() != null) {
                out.println("AutoScaleCount          : " + resource.getAutoScaleCount());
            }
            if (resource.getPrivateLanCount() != null) {
                out.println("PrivateLanCount         : " + resource.getPrivateLanCount());
            }
            if (resource.getPrivateLanClassicCount() != null) {
                out.println("PrivateLanClassicCount  : " + resource.getPrivateLanClassicCount());
            }
            if (resource.getPremiumSupports() != null) {
                out.println("PremiumSupports");
                List<String> premiumSupports = resource.getPremiumSupports();
                for (String premiumSupport : premiumSupports) {
                    out.println("  SupportName           : " + premiumSupport);
                }
            }
            if (resource.getNiftyMultiAccountCount() != null) {
                out.println("NiftyMultiAccountCount  : " + resource.getNiftyMultiAccountCount());
            }
            if (resource.getElasticLoadBalancerCount() != null) {
                out.println(
                    "ElasticLoadBalancerCount: " + resource.getElasticLoadBalancerCount());
            }
            if (resource.getNetworkInterfaceItemSets() != null) {
                out.println("NetworkInterface");
                List<ResourceNetworkInterface> resourceNetworkInterfaces =
                    resource.getNetworkInterfaceItemSets();
                for (ResourceNetworkInterface resourceNetworkInterface : resourceNetworkInterfaces) {
                    if (resourceNetworkInterface.getType() != null) {
                        out.println(
                            "  Type                  : " + resourceNetworkInterface.getType());
                    }
                    if (resourceNetworkInterface.getCount() != null) {
                        out.println(
                            "  Count                 : " + resourceNetworkInterface.getCount());
                    }
                }
            }
            out.println(
                "=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
