/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nic.NiftyNicClient;
import com.nifty.cloud.sdk.nic.model.Association;
import com.nifty.cloud.sdk.nic.model.Attachment;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesRequest;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesResult;
import com.nifty.cloud.sdk.nic.model.NetworkInterfaceSet;
import com.nifty.cloud.sdk.nic.model.PrivateIpAddressesSet;
import com.nifty.cloud.sdk.nic.model.Tag;

/**
 * DescribeNetworkInterfacesサンプル
 *
 */
public class DescribeNetworkInterfacesSample {

    /**
     * DescribeNetworkInterfacesを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からSSLカテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyNicAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyNicClient client = new NiftyNicClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、DescribeNetworkInterfacesを実行します。
         ***********************************************************************/
        DescribeNetworkInterfacesRequest request = new DescribeNetworkInterfacesRequest();
      /*  List<String> networkInterfaceIds = new ArrayList<String>();
        networkInterfaceIds.add("networkInterfaceId");
        request.setNetworkInterfaceIds(networkInterfaceIds);
        List<Filter> filters = new ArrayList<Filter>();
        request.setFilters(filters);*/
        invokeDescribeNetworkInterfaces(client, request);
    }

    /**
     * DescribeNetworkInterfaces 実行サンプル 設定されたリクエストから DescribeNetworkInterfacesを実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeDescribeNetworkInterfaces(
        NiftyNicClient client, DescribeNetworkInterfacesRequest request) {
        try {
            DescribeNetworkInterfacesResult result = client.describeNetworkInterfaces(request);

            out.println("DescribeNetworkInterfaces Action Response");
            out.println(
                "=============================================================================");

            if (result.getRequestId() != null) {
                out.println("  RequestId        : " + result.getRequestId());
            }
            if (result.getNetworkInterfaceSets() != null) {
                out.println("  NetworkInterfaceSet   ");

                List<NetworkInterfaceSet> networkInterfaceSets = result.getNetworkInterfaceSets();
                for (NetworkInterfaceSet networkInterfaceSet : networkInterfaceSets) {
                    if (networkInterfaceSet.getAssociation() != null) {
                        Association association = networkInterfaceSet.getAssociation();
                        if (association.getAllocationId() != null) {
                            out.println(
                                "    AllocationId       : " + association.getAllocationId());
                        }
                        if (association.getAssociationId() != null) {
                            out.println(
                                "    AssociationId       : " + association.getAssociationId());
                        }
                        if (association.getIpOwnerId() != null) {
                            out.println("    IpOwnerId       : " + association.getIpOwnerId());
                        }
                        if (association.getPublicDnsName() != null) {
                            out.println(
                                "    PublicDnsName       : " + association.getPublicDnsName());
                        }
                        if (association.getPublicIp() != null) {
                            out.println("    PublicIp       : " + association.getPublicIp());
                        }
                    }
                    if (networkInterfaceSet.getAttachment() != null) {
                        Attachment attachment = networkInterfaceSet.getAttachment();
                        out.println("  AttachmentId     ");
                        if (attachment.getAttachmentId() != null) {
                            out.println(
                                "    AttachmentId      : " + attachment.getAttachmentId());
                        }

                        if (attachment.getAttachTime() != null) {
                            out.println("    AttachTime      : " + attachment.getAttachTime());
                        }
                        if (attachment.getDeleteOnTermination() != null) {
                            out.println(
                                "    DeleteOnTermination      : "
                                    + attachment.getDeleteOnTermination());
                        }

                        if (attachment.getDeviceIndex() != null) {
                            out.println(
                                "    DeviceIndex      : " + attachment.getDeviceIndex());
                        }
                        if (attachment.getInstanceId() != null) {
                            out.println(
                                "    InstanceId      : " + attachment.getInstanceId());
                        }
                        if (attachment.getInstanceOwnerId() != null) {
                            out.println("    InstanceOwnerId      : "
                                + attachment.getInstanceOwnerId());
                        }
                        if (attachment.getStatus() != null) {
                            out.println("    Status      : " + attachment.getStatus());
                        }
                    }
                    if (networkInterfaceSet.getAvailabilityZone() != null) {
                        out.println(
                            "  AvailabilityZone      : "
                                + networkInterfaceSet.getAvailabilityZone());
                    }
                    if (networkInterfaceSet.getDescription() != null) {
                        out.println("  Description      : " + networkInterfaceSet.getDescription());
                    }
                    if (networkInterfaceSet.getGroupIds() != null) {
                        List<String> groupIds = networkInterfaceSet.getGroupIds();
                        out.println("  GroupIds");
                        for (String groupId : groupIds) {
                            if (groupId != null) {
                                out.println("    GroupId      : " + groupId);
                            }
                        }
                    }
                    if (networkInterfaceSet.getInterfaceType() != null) {
                        out.println(
                            "  InterfaceType      : " + networkInterfaceSet.getInterfaceType());
                    }
                    if (networkInterfaceSet.getIpv6Addresses() != null) {
                        List<String> ipv6Addresses = networkInterfaceSet.getIpv6Addresses();
                        out.println("  Ipv6AddressesSet");
                        for (String ipv6Address : ipv6Addresses) {
                            if (ipv6Address != null) {
                                out.println("    Ipv6Addresses      : " + ipv6Address);
                            }
                        }
                    }
                    if (networkInterfaceSet.getMacAddress() != null) {
                        out.println("  MacAddress      : " + networkInterfaceSet.getMacAddress());
                    }
                    if (networkInterfaceSet.getNetworkInterfaceId() != null) {
                        out.println(
                            "  NetworkInterfaceId      : "
                                + networkInterfaceSet.getNetworkInterfaceId());
                    }
                    if (networkInterfaceSet.getOwnerId() != null) {
                        out.println("  OwnerId      : " + networkInterfaceSet.getOwnerId());
                    }
                    if (networkInterfaceSet.getPrivateDnsName() != null) {
                        out.println(
                            "  PrivateDnsName      : " + networkInterfaceSet.getPrivateDnsName());
                    }
                    if (networkInterfaceSet.getPrivateIpAddress() != null) {
                        out.println(
                            "  PrivateIpAddress      : "
                                + networkInterfaceSet.getPrivateIpAddress());

                    }
                    if (networkInterfaceSet.getPrivateIpAddressesSets() != null) {
                        List<PrivateIpAddressesSet> privateIpAddressesSets =
                            networkInterfaceSet.getPrivateIpAddressesSets();
                        for (PrivateIpAddressesSet privateIpAddressesSet : privateIpAddressesSets) {
                            out.println("  PrivateIpAddressesSets");
                            if (privateIpAddressesSet.getAssociation() != null) {
                                out.println("    Association");
                                if (privateIpAddressesSet.getAssociation()
                                    .getAllocationId() != null) {
                                    out.println("      AllocationId      : " +
                                        privateIpAddressesSet.getAssociation().getAllocationId());
                                }
                                if (privateIpAddressesSet.getAssociation()
                                    .getAssociationId() != null) {
                                    out.println("      AssociationId      : " +
                                        privateIpAddressesSet.getAssociation().getAssociationId());
                                }
                                if (privateIpAddressesSet.getAssociation().getIpOwnerId() != null) {
                                    out.println("      IpOwnerId      : " +
                                        privateIpAddressesSet.getAssociation().getIpOwnerId());
                                }
                                if (privateIpAddressesSet.getAssociation()
                                    .getPublicDnsName() != null) {
                                    out.println("      PublicDnsName      : " +
                                        privateIpAddressesSet.getAssociation().getPublicDnsName());
                                }
                                if (privateIpAddressesSet.getAssociation().getPublicIp() != null) {
                                    out.println("      PublicIp      : " +
                                        privateIpAddressesSet.getAssociation().getPublicIp());
                                }
                            }

                            if (privateIpAddressesSet.getPrimary() != null) {
                                out.println("    Primary      : "
                                    + privateIpAddressesSet.getPrimary());
                            }
                            if (privateIpAddressesSet.getPrivateDnsName() != null) {
                                out.println("    PrivateDnsName      : "
                                    + privateIpAddressesSet.getPrivateDnsName());
                            }
                            if (privateIpAddressesSet.getPrivateIpAddress() != null) {
                                out.println("    PrivateIpAddress      : "
                                    + privateIpAddressesSet.getPrivateIpAddress());
                            }
                        }
                    }

                    if (networkInterfaceSet.getRequesterId() != null) {
                        out.println("  RequesterId      : " + networkInterfaceSet.getRequesterId());
                    }

                    if (networkInterfaceSet.getRequesterManaged() != null) {
                        out.println(
                            "  RequesterManaged      : "
                                + networkInterfaceSet.getRequesterManaged());
                    }

                    if (networkInterfaceSet.getSourceDestCheck() != null) {
                        out.println(
                            "  SourceDestCheck      : " + networkInterfaceSet.getSourceDestCheck());
                    }
                    if (networkInterfaceSet.getStatus() != null) {
                        out.println("  Status      : " +
                            networkInterfaceSet.getStatus());
                    }
                    if (networkInterfaceSet.getSubnetId() != null) {
                        out.println("  SubnetId      : " + networkInterfaceSet.getSubnetId());
                    }

                    if (networkInterfaceSet.getTagSets() != null) {
                        List<Tag> tagSet =
                            networkInterfaceSet.getTagSets();
                        for (Tag tag : tagSet) {
                            out.println("  TagSet");
                            if (tag.getKey() != null) {
                                out.println("    Key                            : " +
                                    tag.getKey());
                            }
                            if (tag.getValue() != null) {
                                out.println(
                                    "    Value                          : " + tag.getValue());
                            }
                        }
                    }
                    if (networkInterfaceSet.getVpcId() != null) {
                        out.println(
                            "  VpcId                          : " + networkInterfaceSet.getVpcId());
                    }
                    if (networkInterfaceSet.getNiftyNetworkId() != null) {
                        out.println("  NiftyNetworkId                          : " +
                            networkInterfaceSet.getNiftyNetworkId());
                    }
                    if (networkInterfaceSet.getNiftyNetworkName() != null) {
                        out.println("  NiftyNetworkName                          : " +
                            networkInterfaceSet.getNiftyNetworkName());
                    }
                }

            }

            out.println(
                "=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }

}
