/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nic.NiftyNicClient;
import com.nifty.cloud.sdk.nic.model.Association;
import com.nifty.cloud.sdk.nic.model.Attachment;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.NetworkInterface;
import com.nifty.cloud.sdk.nic.model.PrivateIpAddressesSet;
import com.nifty.cloud.sdk.nic.model.Tag;

/**
 * CreateNetworkInterfaceサンプル
 *
 */
public class CreateNetworkInterfaceSample {

    /**
     * CreateNetworkInterfaceを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {
        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からイメージカテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyNicAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyNicClient client = new NiftyNicClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、CreateNetworkInterfaceを実行します。
         ***********************************************************************/
        CreateNetworkInterfaceRequest request = new CreateNetworkInterfaceRequest();
        // request.setNiftyNetworkId("NiftyNetworkId");
        // request.setIpAddress("ipAddress");
        // request.setNiftyNetworkId("niftyNetworkId");
        // Placement placement = new Placement();
        // placement.setAvailabilityZone("availabilityZone");

        invokeCreateNetworkInterface(client, request);

    }

    /**
     * CreateNetworkInterface 実行サンプル 設定されたリクエストから CreateNetworkInterface を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeCreateNetworkInterface(NiftyNicClient client,
        CreateNetworkInterfaceRequest request) {
        try {
            CreateNetworkInterfaceResult result = client.createNetworkInterface(request);

            out.println("CreateNetworkInterface Action Response");
            out.println(
                "=============================================================================");

            if (result.getRequestId() != null) {
                out.println("  RequestId        : " + result.getRequestId());
            }
            if (result.getReturn() != null) {
                out.println("  Return        : " + result.getReturn());
            }
            if (result.getNetworkInterface() != null) {
                out.println("  NetworkInterface   ");
                NetworkInterface networkInterface = result.getNetworkInterface();

                if (networkInterface.getAssociation() != null) {
                    Association association = networkInterface.getAssociation();
                    if (association.getAllocationId() != null) {
                        out.println(
                            "    AllocationId       : " + association.getAllocationId());
                    }
                    if (association.getAssociationId() != null) {
                        out.println(
                            "    AssociationId       : " + association.getAssociationId());
                    }
                    if (association.getIpOwnerId() != null) {
                        out.println("    IpOwnerId       : " + association.getIpOwnerId());
                    }
                    if (association.getPublicDnsName() != null) {
                        out.println(
                            "    PublicDnsName       : " + association.getPublicDnsName());
                    }
                    if (association.getPublicIp() != null) {
                        out.println("    PublicIp       : " + association.getPublicIp());
                    }
                }
                if (networkInterface.getAttachment() != null) {
                    Attachment attachment = networkInterface.getAttachment();
                    out.println("  AttachmentId     ");
                    if (attachment.getAttachmentId() != null) {
                        out.println(
                            "    AttachmentId      : " + attachment.getAttachmentId());
                    }

                    if (attachment.getAttachTime() != null) {
                        out.println("    AttachTime      : " + attachment.getAttachTime());
                    }
                    if (attachment.getDeleteOnTermination() != null) {
                        out.println(
                            "    DeleteOnTermination      : "
                                + attachment.getDeleteOnTermination());
                    }

                    if (attachment.getDeviceIndex() != null) {
                        out.println(
                            "    DeviceIndex      : " + attachment.getDeviceIndex());
                    }
                    if (attachment.getInstanceId() != null) {
                        out.println(
                            "    InstanceId      : " + attachment.getInstanceId());
                    }
                    if (attachment.getInstanceOwnerId() != null) {
                        out.println("    InstanceOwnerId      : "
                            + attachment.getInstanceOwnerId());
                    }
                    if (attachment.getStatus() != null) {
                        out.println("    Status      : " + attachment.getStatus());
                    }
                }
                if (networkInterface.getAvailabilityZone() != null) {
                    out.println(
                        "  AvailabilityZone      : " + networkInterface.getAvailabilityZone());
                }
                if (networkInterface.getDescription() != null) {
                    out.println("  Description      : " + networkInterface.getDescription());
                }
                if (networkInterface.getGroupIds() != null) {
                    List<String> groupIds = networkInterface.getGroupIds();
                    out.println("  GroupIds");
                    for (String groupId : groupIds) {
                        if (groupId != null) {
                            out.println("    GroupId      : " + groupId);
                        }
                    }
                }
                if (networkInterface.getInterfaceType() != null) {
                    out.println("  InterfaceType      : " + networkInterface.getInterfaceType());
                }
                if (networkInterface.getIpv6Addresses() != null) {
                    List<String> ipv6Addresses = networkInterface.getIpv6Addresses();
                    out.println("  Ipv6AddressesSet");
                    for (String ipv6Address : ipv6Addresses) {
                        if (ipv6Address != null) {
                            out.println("    Ipv6Addresses      : " + ipv6Address);
                        }
                    }
                }
                if (networkInterface.getMacAddress() != null) {
                    out.println("  MacAddress      : " + networkInterface.getMacAddress());
                }
                if (networkInterface.getNetworkInterfaceId() != null) {
                    out.println(
                        "  NetworkInterfaceId      : " + networkInterface.getNetworkInterfaceId());
                }
                if (networkInterface.getOwnerId() != null) {
                    out.println("  OwnerId      : " + networkInterface.getOwnerId());
                }
                if (networkInterface.getPrivateDnsName() != null) {
                    out.println("  PrivateDnsName      : " + networkInterface.getPrivateDnsName());
                }
                if (networkInterface.getPrivateIpAddress() != null) {
                    out.println(
                        "  PrivateIpAddress      : " + networkInterface.getPrivateIpAddress());

                }
                if (networkInterface.getPrivateIpAddressesSets() != null) {
                    List<PrivateIpAddressesSet> privateIpAddressesSets =
                        networkInterface.getPrivateIpAddressesSets();
                    for (PrivateIpAddressesSet privateIpAddressesSet : privateIpAddressesSets) {
                        out.println("  PrivateIpAddressesSets");
                        if (privateIpAddressesSet.getAssociation() != null) {
                            out.println("    Association");
                            if (privateIpAddressesSet.getAssociation().getAllocationId() != null) {
                                out.println("      AllocationId      : " +
                                    privateIpAddressesSet.getAssociation().getAllocationId());
                            }
                            if (privateIpAddressesSet.getAssociation().getAssociationId() != null) {
                                out.println("      AssociationId      : " +
                                    privateIpAddressesSet.getAssociation().getAssociationId());
                            }
                            if (privateIpAddressesSet.getAssociation().getIpOwnerId() != null) {
                                out.println("      IpOwnerId      : " +
                                    privateIpAddressesSet.getAssociation().getIpOwnerId());
                            }
                            if (privateIpAddressesSet.getAssociation().getPublicDnsName() != null) {
                                out.println("      PublicDnsName      : " +
                                    privateIpAddressesSet.getAssociation().getPublicDnsName());
                            }
                            if (privateIpAddressesSet.getAssociation().getPublicIp() != null) {
                                out.println("      PublicIp      : " +
                                    privateIpAddressesSet.getAssociation().getPublicIp());
                            }
                        }

                        if (privateIpAddressesSet.getPrimary() != null) {
                            out.println("    Primary      : "
                                + privateIpAddressesSet.getPrimary());
                        }
                        if (privateIpAddressesSet.getPrivateDnsName() != null) {
                            out.println("    PrivateDnsName      : "
                                + privateIpAddressesSet.getPrivateDnsName());
                        }
                        if (privateIpAddressesSet.getPrivateIpAddress() != null) {
                            out.println("    PrivateIpAddress      : "
                                + privateIpAddressesSet.getPrivateIpAddress());
                        }
                    }
                }

                if (networkInterface.getRequesterId() != null) {
                    out.println("  RequesterId      : " + networkInterface.getRequesterId());
                }

                if (networkInterface.getRequesterManaged() != null) {
                    out.println(
                        "  RequesterManaged      : " + networkInterface.getRequesterManaged());
                }

                if (networkInterface.getSourceDestCheck() != null) {
                    out.println(
                        "  SourceDestCheck      : " + networkInterface.getSourceDestCheck());
                }
                if (networkInterface.getStatus() != null) {
                    out.println("  Status      : " +
                        networkInterface.getStatus());
                }
                if (networkInterface.getSubnetId() != null) {
                    out.println("  SubnetId      : " + networkInterface.getSubnetId());
                }

                if (networkInterface.getTagSets() != null) {
                    List<Tag> tagSet =
                        networkInterface.getTagSets();
                    for (Tag tag : tagSet) {
                        out.println("  TagSet");
                        if (tag.getKey() != null) {
                            out.println("    Key                            : " +
                                tag.getKey());
                        }
                        if (tag.getValue() != null) {
                            out.println("    Value                          : " + tag.getValue());
                        }
                    }
                }
                if (networkInterface.getVpcId() != null) {
                    out.println(
                        "  VpcId                          : " + networkInterface.getVpcId());
                }
                if (networkInterface.getNiftyNetworkId() != null) {
                    out.println("  NiftyNetworkId                          : " +
                        networkInterface.getNiftyNetworkId());
                }
                if (networkInterface.getNiftyNetworkName() != null) {
                    out.println("  NiftyNetworkName                          : " +
                        networkInterface.getNiftyNetworkName());
                }

            }

            out.println(
                "=============================================================================");
        } catch (

        NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
