/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model.transform;

import com.nifty.cloud.sdk.routetable.model.RouteTableAssociation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import java.util.ArrayList;
import java.util.List;

/**
 * RouteTableAssociationSetType変換クラス。<br />
 * このクラスはレスポンスXMLのassociationSet要素からRouteTableAssociationクラスのリストを生成します。
 */
public class AssociationSetConverter implements Converter {

	private static final String ELEMENT_ROUTE_TABLE_ASSOCIATION_ID = "routeTableAssociationId";
	private static final String ELEMENT_ROUTE_TABLE_ID = "routeTableId";
	private static final String ELEMENT_SUBNET_ID = "subnetId";
	private static final String ELEMENT_MAIN = "main";
	private static final String ELEMENT_ROUTER_ID = "routerId";
	private static final String ELEMENT_ROUTER_NAME = "routerName";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * associationSetをList<RouteTableAssociation>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<RouteTableAssociation>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<RouteTableAssociation> routeTableAssociations = new ArrayList<RouteTableAssociation>();
		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			RouteTableAssociation routeTableAssociation = new RouteTableAssociation();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_ROUTE_TABLE_ASSOCIATION_ID)) {
					routeTableAssociation.setRouteTableAssociationId(reader.getValue());
				} else if (name.equals(ELEMENT_ROUTE_TABLE_ID)) {
					routeTableAssociation.setRouteTableId(reader.getValue());
				} else if (name.equals(ELEMENT_SUBNET_ID)) {
					routeTableAssociation.setSubnetId(reader.getValue());
				} else if (name.equals(ELEMENT_MAIN)) {
					routeTableAssociation.setMain(Boolean.valueOf(reader.getValue()));
				} else if (name.equals(ELEMENT_ROUTER_ID)) {
					routeTableAssociation.setRouterId(reader.getValue());
				} else if (name.equals(ELEMENT_ROUTER_NAME)) {
					routeTableAssociation.setRouterName(reader.getValue());
				}

				reader.moveUp();
			}
			routeTableAssociations.add(routeTableAssociation);
			reader.moveUp();
		}

		return routeTableAssociations;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
