/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * ルートテーブル情報セットクラス。<br />
 * このクラスはルートテーブル情報セットを格納します。
 *
 */
public class RouteTableSet {

	/** ルートテーブルID */
	private String routeTableId;

	private String vpcId;

	/** ルート情報 */
	private List<Route> routes;

	/** ルートテーブル適用情報 */
	private List<RouteTableAssociation> associations;

	/** VPNゲートウェイ伝播経路情報 */
	private List<PropagatingVgw> propagatingVgws;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public RouteTableSet withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * vpcIdを取得します。
	 *
	 * @return vpcId
	 */
	public String getVpcId() {
		return vpcId;
	}

	/**
	 * vpcIdを設定します。
	 *
	 * @param vpcId
	 */
	public void setVpcId(String vpcId) {
		this.vpcId = vpcId;
	}

	/**
	 * vpcIdを設定し、自オブジェクトを返します。
	 *
	 * @param vpcId
	 * @return 自オブジェクト
	 */
	public RouteTableSet withVpcId(String vpcId) {
		setVpcId(vpcId);
		return this;
	}

	/**
	 * ルート情報を取得します。
	 *
	 * @return ルート情報
	 */
	public List<Route> getRoutes() {
		return routes;
	}

	/**
	 * ルート情報を設定します。
	 *
	 * @param routes ルート情報
	 */
	public void setRoutes(List<Route> routes) {
		this.routes = routes;
	}

	/**
	 * ルート情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param routes ルート情報の配列
	 * @return 自オブジェクト
	 */
	public RouteTableSet withRoutes(Route ... routes) {
		if (this.routes == null) this.routes = new ArrayList<Route>();
		for (Route route : routes) {
			getRoutes().add(route);
		}
		return this;
	}

	/**
	 * ルート情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param routes ルート情報リスト
	 * @return 自オブジェクト
	 */
	public RouteTableSet withRoutes(Collection<Route> routes) {
		if (this.routes == null) this.routes = new ArrayList<Route>();
		if (routes != null) {
			getRoutes().addAll(routes);
		}
		return this;
	}

	/**
	 * ルートテーブル適用情報を取得します。
	 *
	 * @return ルートテーブル適用情報
	 */
	public List<RouteTableAssociation> getAssociations() {
		return associations;
	}

	/**
	 * ルートテーブル適用情報を設定します。
	 *
	 * @param associations ルートテーブル適用情報
	 */
	public void setAssociations(List<RouteTableAssociation> associations) {
		this.associations = associations;
	}

	/**
	 * ルートテーブル適用情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param associations ルートテーブル適用情報の配列
	 * @return 自オブジェクト
	 */
	public RouteTableSet withAssociations(RouteTableAssociation ... associations) {
		if (this.associations == null) this.associations = new ArrayList<RouteTableAssociation>();
		for (RouteTableAssociation association : associations) {
			getAssociations().add(association);
		}
		return this;
	}

	/**
	 * ルートテーブル適用情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param associations ルートテーブル適用情報リスト
	 * @return 自オブジェクト
	 */
	public RouteTableSet withAssociations(Collection<RouteTableAssociation> associations) {
		if (this.associations == null) this.associations = new ArrayList<RouteTableAssociation>();
		if (associations != null) {
			getAssociations().addAll(associations);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ伝播経路情報を取得します。
	 *
	 * @return VPNゲートウェイ伝播経路情報
	 */
	public List<PropagatingVgw> getPropagatingVgws() {
		return propagatingVgws;
	}

	/**
	 * VPNゲートウェイ伝播経路情報を設定します。
	 *
	 * @param propagatingVgws VPNゲートウェイ伝播経路情報
	 */
	public void setPropagatingVgws(List<PropagatingVgw> propagatingVgws) {
		this.propagatingVgws = propagatingVgws;
	}

	/**
	 * VPNゲートウェイ伝播経路情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param propagatingVgws VPNゲートウェイ伝播経路情報の配列
	 * @return 自オブジェクト
	 */
	public RouteTableSet withPropagatingVgws(PropagatingVgw ... propagatingVgws) {
		if (this.propagatingVgws == null) this.propagatingVgws = new ArrayList<PropagatingVgw>();
		for (PropagatingVgw propagatingVgw : propagatingVgws) {
			getPropagatingVgws().add(propagatingVgw);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ伝播経路情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param propagatingVgws VPNゲートウェイ伝播経路情報リスト
	 * @return 自オブジェクト
	 */
	public RouteTableSet withPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
		if (this.propagatingVgws == null) this.propagatingVgws = new ArrayList<PropagatingVgw>();
		if (propagatingVgws != null) {
			getPropagatingVgws().addAll(propagatingVgws);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public RouteTableSet withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public RouteTableSet withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableId=");
		builder.append(routeTableId);
		builder.append(", vpcId=");
		builder.append(vpcId);
		builder.append(", routes=");
		builder.append(routes);
		builder.append(", associations=");
		builder.append(associations);
		builder.append(", propagatingVgws=");
		builder.append(propagatingVgws);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append("]");
		return builder.toString();
	}
}
