/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

/**
 * ルートテーブル適用情報クラス。<br />
 * このクラスはルートテーブル適用情報を格納します。
 *
 */
public class RouteTableAssociation {

	/** ルートテーブル適用ID */
	private String routeTableAssociationId;

	/** ルートテーブルID */
	private String routeTableId;

	private String subnetId;

	/** メインルートテーブルフラグ */
	private Boolean main;

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	public String getRouteTableAssociationId() {
		return routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 */
	public void setRouteTableAssociationId(String routeTableAssociationId) {
		this.routeTableAssociationId = routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withRouteTableAssociationId(String routeTableAssociationId) {
		setRouteTableAssociationId(routeTableAssociationId);
		return this;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * subnetIdを取得します。
	 *
	 * @return subnetId
	 */
	public String getSubnetId() {
		return subnetId;
	}

	/**
	 * subnetIdを設定します。
	 *
	 * @param subnetId
	 */
	public void setSubnetId(String subnetId) {
		this.subnetId = subnetId;
	}

	/**
	 * subnetIdを設定し、自オブジェクトを返します。
	 *
	 * @param subnetId
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withSubnetId(String subnetId) {
		setSubnetId(subnetId);
		return this;
	}

	/**
	 * メインルートテーブルフラグを取得します。
	 *
	 * @return メインルートテーブルフラグ
	 */
	public Boolean getMain() {
		return main;
	}

	/**
	 * メインルートテーブルフラグを設定します。
	 *
	 * @param main メインルートテーブルフラグ
	 */
	public void setMain(Boolean main) {
		this.main = main;
	}

	/**
	 * メインルートテーブルフラグを設定し、自オブジェクトを返します。
	 *
	 * @param main メインルートテーブルフラグ
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withMain(Boolean main) {
		setMain(main);
		return this;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public RouteTableAssociation withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableAssociationId=");
		builder.append(routeTableAssociationId);
		builder.append(", routeTableId=");
		builder.append(routeTableId);
		builder.append(", subnetId=");
		builder.append(subnetId);
		builder.append(", main=");
		builder.append(main);
		builder.append(", routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append("]");
		return builder.toString();
	}
}
