/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

/**
 * ルート情報クラス。<br />
 * このクラスはルート情報を格納します。
 *
 */
public class Route {

	/** 宛先のCIDR */
	private String destinationCidrBlock;

	private String gatewayId;

	private String instanceId;

	private String instanceOwnerId;

	private String networkInterfaceId;

	/** ターゲットのIPアドレス */
	private String ipAddress;

	/** ターゲットのネットワークID */
	private String networkId;

	/** ターゲットのネットワーク名 */
	private String networkName;

	/** ルートの状態 */
	private String state;

	/** ルート作成方法 */
	private String origin;

	/** 優先順位 */
	private String priority;

	/** VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ) */
	private String vpcPeeringConnectionId;

	/**
	 * 宛先のCIDRを取得します。
	 *
	 * @return 宛先のCIDR
	 */
	public String getDestinationCidrBlock() {
		return destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 */
	public void setDestinationCidrBlock(String destinationCidrBlock) {
		this.destinationCidrBlock = destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定し、自オブジェクトを返します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 * @return 自オブジェクト
	 */
	public Route withDestinationCidrBlock(String destinationCidrBlock) {
		setDestinationCidrBlock(destinationCidrBlock);
		return this;
	}

	/**
	 * gatewayIdを取得します。
	 *
	 * @return gatewayId
	 */
	public String getGatewayId() {
		return gatewayId;
	}

	/**
	 * gatewayIdを設定します。
	 *
	 * @param gatewayId
	 */
	public void setGatewayId(String gatewayId) {
		this.gatewayId = gatewayId;
	}

	/**
	 * gatewayIdを設定し、自オブジェクトを返します。
	 *
	 * @param gatewayId
	 * @return 自オブジェクト
	 */
	public Route withGatewayId(String gatewayId) {
		setGatewayId(gatewayId);
		return this;
	}

	/**
	 * instanceIdを取得します。
	 *
	 * @return instanceId
	 */
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * instanceIdを設定します。
	 *
	 * @param instanceId
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * instanceIdを設定し、自オブジェクトを返します。
	 *
	 * @param instanceId
	 * @return 自オブジェクト
	 */
	public Route withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * instanceOwnerIdを取得します。
	 *
	 * @return instanceOwnerId
	 */
	public String getInstanceOwnerId() {
		return instanceOwnerId;
	}

	/**
	 * instanceOwnerIdを設定します。
	 *
	 * @param instanceOwnerId
	 */
	public void setInstanceOwnerId(String instanceOwnerId) {
		this.instanceOwnerId = instanceOwnerId;
	}

	/**
	 * instanceOwnerIdを設定し、自オブジェクトを返します。
	 *
	 * @param instanceOwnerId
	 * @return 自オブジェクト
	 */
	public Route withInstanceOwnerId(String instanceOwnerId) {
		setInstanceOwnerId(instanceOwnerId);
		return this;
	}

	/**
	 * networkInterfaceIdを取得します。
	 *
	 * @return networkInterfaceId
	 */
	public String getNetworkInterfaceId() {
		return networkInterfaceId;
	}

	/**
	 * networkInterfaceIdを設定します。
	 *
	 * @param networkInterfaceId
	 */
	public void setNetworkInterfaceId(String networkInterfaceId) {
		this.networkInterfaceId = networkInterfaceId;
	}

	/**
	 * networkInterfaceIdを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaceId
	 * @return 自オブジェクト
	 */
	public Route withNetworkInterfaceId(String networkInterfaceId) {
		setNetworkInterfaceId(networkInterfaceId);
		return this;
	}

	/**
	 * ターゲットのIPアドレスを取得します。
	 *
	 * @return ターゲットのIPアドレス
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * ターゲットのIPアドレスを設定します。
	 *
	 * @param ipAddress ターゲットのIPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * ターゲットのIPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress ターゲットのIPアドレス
	 * @return 自オブジェクト
	 */
	public Route withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * ターゲットのネットワークIDを取得します。
	 *
	 * @return ターゲットのネットワークID
	 */
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ターゲットのネットワークIDを設定します。
	 *
	 * @param networkId ターゲットのネットワークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ターゲットのネットワークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ターゲットのネットワークID
	 * @return 自オブジェクト
	 */
	public Route withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ターゲットのネットワーク名を取得します。
	 *
	 * @return ターゲットのネットワーク名
	 */
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ターゲットのネットワーク名を設定します。
	 *
	 * @param networkName ターゲットのネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ターゲットのネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ターゲットのネットワーク名
	 * @return 自オブジェクト
	 */
	public Route withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * ルートの状態を取得します。
	 *
	 * @return ルートの状態
	 */
	public String getState() {
		return state;
	}

	/**
	 * ルートの状態を設定します。
	 *
	 * @param state ルートの状態
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * ルートの状態を設定し、自オブジェクトを返します。
	 *
	 * @param state ルートの状態
	 * @return 自オブジェクト
	 */
	public Route withState(String state) {
		setState(state);
		return this;
	}

	/**
	 * ルート作成方法を取得します。
	 *
	 * @return ルート作成方法
	 */
	public String getOrigin() {
		return origin;
	}

	/**
	 * ルート作成方法を設定します。
	 *
	 * @param origin ルート作成方法
	 */
	public void setOrigin(String origin) {
		this.origin = origin;
	}

	/**
	 * ルート作成方法を設定し、自オブジェクトを返します。
	 *
	 * @param origin ルート作成方法
	 * @return 自オブジェクト
	 */
	public Route withOrigin(String origin) {
		setOrigin(origin);
		return this;
	}

	/**
	 * 優先順位を取得します。
	 *
	 * @return 優先順位
	 */
	public String getPriority() {
		return priority;
	}

	/**
	 * 優先順位を設定します。
	 *
	 * @param priority 優先順位
	 */
	public void setPriority(String priority) {
		this.priority = priority;
	}

	/**
	 * 優先順位を設定し、自オブジェクトを返します。
	 *
	 * @param priority 優先順位
	 * @return 自オブジェクト
	 */
	public Route withPriority(String priority) {
		setPriority(priority);
		return this;
	}

	/**
	 * VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)を取得します。
	 *
	 * @return VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)
	 */
	public String getVpcPeeringConnectionId() {
		return vpcPeeringConnectionId;
	}

	/**
	 * VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)を設定します。
	 *
	 * @param vpcPeeringConnectionId VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)
	 */
	public void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
		this.vpcPeeringConnectionId = vpcPeeringConnectionId;
	}

	/**
	 * VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)を設定し、自オブジェクトを返します。
	 *
	 * @param vpcPeeringConnectionId VPNコネクションID(VPNゲートウェイから伝搬されたルートのみ)
	 * @return 自オブジェクト
	 */
	public Route withVpcPeeringConnectionId(String vpcPeeringConnectionId) {
		setVpcPeeringConnectionId(vpcPeeringConnectionId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[destinationCidrBlock=");
		builder.append(destinationCidrBlock);
		builder.append(", gatewayId=");
		builder.append(gatewayId);
		builder.append(", instanceId=");
		builder.append(instanceId);
		builder.append(", instanceOwnerId=");
		builder.append(instanceOwnerId);
		builder.append(", networkInterfaceId=");
		builder.append(networkInterfaceId);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", state=");
		builder.append(state);
		builder.append(", origin=");
		builder.append(origin);
		builder.append(", priority=");
		builder.append(priority);
		builder.append(", vpcPeeringConnectionId=");
		builder.append(vpcPeeringConnectionId);
		builder.append("]");
		return builder.toString();
	}
}
