/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

/**
 * VPNゲートウェイ伝播経路情報クラス。<br />
 * このクラスはVPNゲートウェイ伝播経路情報を格納します。
 *
 */
public class PropagatingVgw {

	/** VPNゲートウェイユニークID */
	private String gatewayId;

	/** VPNゲートウェイ名 */
	private String niftyGatewayName;

	/** ルートテーブル適用ID */
	private String routeTableAssociationId;

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	public String getGatewayId() {
		return gatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param gatewayId VPNゲートウェイユニークID
	 */
	public void setGatewayId(String gatewayId) {
		this.gatewayId = gatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param gatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public PropagatingVgw withGatewayId(String gatewayId) {
		setGatewayId(gatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyGatewayName() {
		return niftyGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyGatewayName VPNゲートウェイ名
	 */
	public void setNiftyGatewayName(String niftyGatewayName) {
		this.niftyGatewayName = niftyGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public PropagatingVgw withNiftyGatewayName(String niftyGatewayName) {
		setNiftyGatewayName(niftyGatewayName);
		return this;
	}

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	public String getRouteTableAssociationId() {
		return routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 */
	public void setRouteTableAssociationId(String routeTableAssociationId) {
		this.routeTableAssociationId = routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public PropagatingVgw withRouteTableAssociationId(String routeTableAssociationId) {
		setRouteTableAssociationId(routeTableAssociationId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[gatewayId=");
		builder.append(gatewayId);
		builder.append(", niftyGatewayName=");
		builder.append(niftyGatewayName);
		builder.append(", routeTableAssociationId=");
		builder.append(routeTableAssociationId);
		builder.append("]");
		return builder.toString();
	}
}
