/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DisassociateRouteTableリクエストクラス。<br />
 * このクラスはDisassociateRouteTableへのリクエストを構築します。
 *
 */
@Action("DisassociateRouteTable")
public class DisassociateRouteTableRequest implements Request {

	/** ルートテーブル適用ID */
	private String associationId;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public DisassociateRouteTableRequest() {
	}

	/**
	 * ルートテーブル適用IDを指定し、DisassociateRouteTableRequestを構築します。
	 *
	 * @param associationId ルートテーブル適用ID
	 */
	public DisassociateRouteTableRequest(String associationId) {
		this.associationId = associationId;
	}

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	@Query(name="AssociationId", require=true)
	public String getAssociationId() {
		return associationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param associationId ルートテーブル適用ID
	 */
	public void setAssociationId(String associationId) {
		this.associationId = associationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param associationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public DisassociateRouteTableRequest withAssociationId(String associationId) {
		setAssociationId(associationId);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public DisassociateRouteTableRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[associationId=");
		builder.append(associationId);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
