/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.routetable.model.transform.DescribeRouteTablesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * DescribeRouteTables処理結果クラス。<br />
 * このクラスはDescribeRouteTablesのレスポンスを格納します。
 */
@XStreamAlias("DescribeRouteTablesResponse")
@XStreamConverter(DescribeRouteTablesResultConverter.class)
public class DescribeRouteTablesResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** ルートテーブル情報リスト */
	private List<RouteTableSet> routeTables;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * ルートテーブル情報リストを取得します。
	 *
	 * @return ルートテーブル情報リスト
	 */
	public List<RouteTableSet> getRouteTables() {
		return routeTables;
	}

	/**
	 * ルートテーブル情報リストを設定します。
	 *
	 * @param routeTables ルートテーブル情報リスト
	 */
	public void setRouteTables(List<RouteTableSet> routeTables) {
		this.routeTables = routeTables;
	}

	/**
	 * ルートテーブル情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param routeTables ルートテーブル情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesResult withRouteTables(RouteTableSet ... routeTables) {
		if (this.routeTables == null) this.routeTables = new ArrayList<RouteTableSet>();
		for (RouteTableSet routeTable : routeTables) {
			getRouteTables().add(routeTable);
		}
		return this;
	}

	/**
	 * ルートテーブル情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param routeTables ルートテーブル情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesResult withRouteTables(Collection<RouteTableSet> routeTables) {
		if (this.routeTables == null) this.routeTables = new ArrayList<RouteTableSet>();
		if (routeTables != null) {
			getRouteTables().addAll(routeTables);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", routeTables=");
		builder.append(routeTables);
		builder.append("]");
		return builder.toString();
	}
}
