/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * DescribeRouteTablesリクエストクラス。<br />
 * このクラスはDescribeRouteTablesへのリクエストを構築します。
 *
 */
@Action("DescribeRouteTables")
public class DescribeRouteTablesRequest implements Request {

	/** ルートテーブル情報リスト */
	private List<RouteTableIdSet> routeTables;

	/** 絞り込み情報リスト */
	private List<Filter> filters;

	/**
	 * ルートテーブル情報リストを取得します。
	 *
	 * @return ルートテーブル情報リスト
	 */
	@Query(name="")
	public List<RouteTableIdSet> getRouteTables() {
		return routeTables;
	}

	/**
	 * ルートテーブル情報リストを設定します。
	 *
	 * @param routeTables ルートテーブル情報リスト
	 */
	public void setRouteTables(List<RouteTableIdSet> routeTables) {
		this.routeTables = routeTables;
	}

	/**
	 * ルートテーブル情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param routeTables ルートテーブル情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesRequest withRouteTables(RouteTableIdSet ... routeTables) {
		if (this.routeTables == null) this.routeTables = new ArrayList<RouteTableIdSet>();
		for (RouteTableIdSet routeTable : routeTables) {
			getRouteTables().add(routeTable);
		}
		return this;
	}

	/**
	 * ルートテーブル情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param routeTables ルートテーブル情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesRequest withRouteTables(Collection<RouteTableIdSet> routeTables) {
		if (this.routeTables == null) this.routeTables = new ArrayList<RouteTableIdSet>();
		if (routeTables != null) {
			getRouteTables().addAll(routeTables);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを取得します。
	 *
	 * @return 絞り込み情報リスト
	 */
	@Query(name="Filter")
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 絞り込み情報リストを設定します。
	 *
	 * @param filters 絞り込み情報リスト
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 絞り込み情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesRequest withFilters(Filter ... filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		for (Filter filter : filters) {
			getFilters().add(filter);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeRouteTablesRequest withFilters(Collection<Filter> filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		if (filters != null) {
			getFilters().addAll(filters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTables=");
		builder.append(routeTables);
		builder.append(", filters=");
		builder.append(filters);
		builder.append("]");
		return builder.toString();
	}
}
