/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteRouteTableリクエストクラス。<br />
 * このクラスはDeleteRouteTableへのリクエストを構築します。
 *
 */
@Action("DeleteRouteTable")
public class DeleteRouteTableRequest implements Request {

	/** ルートテーブルID */
	private String routeTableId;

	/**
	 * デフォルトコンストラクタ。
	 */
	public DeleteRouteTableRequest() {
	}

	/**
	 * ルートテーブルIDを指定し、DeleteRouteTableRequestを構築します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public DeleteRouteTableRequest(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	@Query(name="RouteTableId", require=true)
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public DeleteRouteTableRequest withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableId=");
		builder.append(routeTableId);
		builder.append("]");
		return builder.toString();
	}
}
