/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteRouteリクエストクラス。<br />
 * このクラスはDeleteRouteへのリクエストを構築します。
 *
 */
@Action("DeleteRoute")
public class DeleteRouteRequest implements Request {

	/** ルートテーブルID */
	private String routeTableId;

	/** 宛先のCIDR */
	private String destinationCidrBlock;

	/**
	 * デフォルトコンストラクタ。
	 */
	public DeleteRouteRequest() {
	}

	/**
	 * ルートテーブルID,宛先のCIDRを指定し、DeleteRouteRequestを構築します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @param destinationCidrBlock 宛先のCIDR
	 */
	public DeleteRouteRequest(String routeTableId, String destinationCidrBlock) {
		this.routeTableId = routeTableId;
		this.destinationCidrBlock = destinationCidrBlock;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	@Query(name="RouteTableId", require=true)
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public DeleteRouteRequest withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * 宛先のCIDRを取得します。
	 *
	 * @return 宛先のCIDR
	 */
	@Query(name="DestinationCidrBlock", require=true)
	public String getDestinationCidrBlock() {
		return destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 */
	public void setDestinationCidrBlock(String destinationCidrBlock) {
		this.destinationCidrBlock = destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定し、自オブジェクトを返します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 * @return 自オブジェクト
	 */
	public DeleteRouteRequest withDestinationCidrBlock(String destinationCidrBlock) {
		setDestinationCidrBlock(destinationCidrBlock);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableId=");
		builder.append(routeTableId);
		builder.append(", destinationCidrBlock=");
		builder.append(destinationCidrBlock);
		builder.append("]");
		return builder.toString();
	}
}
