/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.routetable.model.transform.CreateRouteTableResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * CreateRouteTable処理結果クラス。<br />
 * このクラスはCreateRouteTableのレスポンスを格納します。
 */
@XStreamAlias("CreateRouteTableResponse")
@XStreamConverter(CreateRouteTableResultConverter.class)
public class CreateRouteTableResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** ルートテーブル情報 */
	private RouteTable routeTable;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public CreateRouteTableResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * ルートテーブル情報を取得します。
	 *
	 * @return ルートテーブル情報
	 */
	public RouteTable getRouteTable() {
		return routeTable;
	}

	/**
	 * ルートテーブル情報を設定します。
	 *
	 * @param routeTable ルートテーブル情報
	 */
	public void setRouteTable(RouteTable routeTable) {
		this.routeTable = routeTable;
	}

	/**
	 * ルートテーブル情報を設定し、自オブジェクトを返します。
	 *
	 * @param routeTable ルートテーブル情報
	 * @return 自オブジェクト
	 */
	public CreateRouteTableResult withRouteTable(RouteTable routeTable) {
		setRouteTable(routeTable);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", routeTable=");
		builder.append(routeTable);
		builder.append("]");
		return builder.toString();
	}
}
