/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * CreateRouteリクエストクラス。<br />
 * このクラスはCreateRouteへのリクエストを構築します。
 *
 */
@Action("CreateRoute")
public class CreateRouteRequest implements Request {

	/** ルートテーブルID */
	private String routeTableId;

	/** 宛先のCIDR */
	private String destinationCidrBlock;

	private String gatewayId;

	private String instanceId;

	private String networkInterfaceId;

	private String vpcPeeringConnectionId;

	/** ターゲットのIPアドレス */
	private String ipAddress;

	/** ターゲットのネットワークID */
	private String networkId;

	/** ターゲットのネットワーク名 */
	private String networkName;

	/**
	 * デフォルトコンストラクタ。
	 */
	public CreateRouteRequest() {
	}

	/**
	 * ルートテーブルIDを指定し、CreateRouteRequestを構築します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public CreateRouteRequest(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	@Query(name="RouteTableId", require=true)
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * 宛先のCIDRを取得します。
	 *
	 * @return 宛先のCIDR
	 */
	@Query(name="DestinationCidrBlock")
	public String getDestinationCidrBlock() {
		return destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 */
	public void setDestinationCidrBlock(String destinationCidrBlock) {
		this.destinationCidrBlock = destinationCidrBlock;
	}

	/**
	 * 宛先のCIDRを設定し、自オブジェクトを返します。
	 *
	 * @param destinationCidrBlock 宛先のCIDR
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withDestinationCidrBlock(String destinationCidrBlock) {
		setDestinationCidrBlock(destinationCidrBlock);
		return this;
	}

	/**
	 * gatewayIdを取得します。
	 *
	 * @return gatewayId
	 */
	@Query(name="GatewayId")
	public String getGatewayId() {
		return gatewayId;
	}

	/**
	 * gatewayIdを設定します。
	 *
	 * @param gatewayId
	 */
	public void setGatewayId(String gatewayId) {
		this.gatewayId = gatewayId;
	}

	/**
	 * gatewayIdを設定し、自オブジェクトを返します。
	 *
	 * @param gatewayId
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withGatewayId(String gatewayId) {
		setGatewayId(gatewayId);
		return this;
	}

	/**
	 * instanceIdを取得します。
	 *
	 * @return instanceId
	 */
	@Query(name="InstanceId")
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * instanceIdを設定します。
	 *
	 * @param instanceId
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * instanceIdを設定し、自オブジェクトを返します。
	 *
	 * @param instanceId
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * networkInterfaceIdを取得します。
	 *
	 * @return networkInterfaceId
	 */
	@Query(name="NetworkInterfaceId")
	public String getNetworkInterfaceId() {
		return networkInterfaceId;
	}

	/**
	 * networkInterfaceIdを設定します。
	 *
	 * @param networkInterfaceId
	 */
	public void setNetworkInterfaceId(String networkInterfaceId) {
		this.networkInterfaceId = networkInterfaceId;
	}

	/**
	 * networkInterfaceIdを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaceId
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withNetworkInterfaceId(String networkInterfaceId) {
		setNetworkInterfaceId(networkInterfaceId);
		return this;
	}

	/**
	 * vpcPeeringConnectionIdを取得します。
	 *
	 * @return vpcPeeringConnectionId
	 */
	@Query(name="VpcPeeringConnectionId")
	public String getVpcPeeringConnectionId() {
		return vpcPeeringConnectionId;
	}

	/**
	 * vpcPeeringConnectionIdを設定します。
	 *
	 * @param vpcPeeringConnectionId
	 */
	public void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
		this.vpcPeeringConnectionId = vpcPeeringConnectionId;
	}

	/**
	 * vpcPeeringConnectionIdを設定し、自オブジェクトを返します。
	 *
	 * @param vpcPeeringConnectionId
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withVpcPeeringConnectionId(String vpcPeeringConnectionId) {
		setVpcPeeringConnectionId(vpcPeeringConnectionId);
		return this;
	}

	/**
	 * ターゲットのIPアドレスを取得します。
	 *
	 * @return ターゲットのIPアドレス
	 */
	@Query(name="IpAddress")
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * ターゲットのIPアドレスを設定します。
	 *
	 * @param ipAddress ターゲットのIPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * ターゲットのIPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress ターゲットのIPアドレス
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * ターゲットのネットワークIDを取得します。
	 *
	 * @return ターゲットのネットワークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ターゲットのネットワークIDを設定します。
	 *
	 * @param networkId ターゲットのネットワークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ターゲットのネットワークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ターゲットのネットワークID
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ターゲットのネットワーク名を取得します。
	 *
	 * @return ターゲットのネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ターゲットのネットワーク名を設定します。
	 *
	 * @param networkName ターゲットのネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ターゲットのネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ターゲットのネットワーク名
	 * @return 自オブジェクト
	 */
	public CreateRouteRequest withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableId=");
		builder.append(routeTableId);
		builder.append(", destinationCidrBlock=");
		builder.append(destinationCidrBlock);
		builder.append(", gatewayId=");
		builder.append(gatewayId);
		builder.append(", instanceId=");
		builder.append(instanceId);
		builder.append(", networkInterfaceId=");
		builder.append(networkInterfaceId);
		builder.append(", vpcPeeringConnectionId=");
		builder.append(vpcPeeringConnectionId);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append("]");
		return builder.toString();
	}
}
