/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * AssociateRouteTableリクエストクラス。<br />
 * このクラスはAssociateRouteTableへのリクエストを構築します。
 *
 */
@Action("AssociateRouteTable")
public class AssociateRouteTableRequest implements Request {

	/** ルートテーブルID */
	private String routeTableId;

	private String subnetId;

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public AssociateRouteTableRequest() {
	}

	/**
	 * ルートテーブルIDを指定し、AssociateRouteTableRequestを構築します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public AssociateRouteTableRequest(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	@Query(name="RouteTableId", require=true)
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public AssociateRouteTableRequest withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * subnetIdを取得します。
	 *
	 * @return subnetId
	 */
	@Query(name="SubnetId")
	public String getSubnetId() {
		return subnetId;
	}

	/**
	 * subnetIdを設定します。
	 *
	 * @param subnetId
	 */
	public void setSubnetId(String subnetId) {
		this.subnetId = subnetId;
	}

	/**
	 * subnetIdを設定し、自オブジェクトを返します。
	 *
	 * @param subnetId
	 * @return 自オブジェクト
	 */
	public AssociateRouteTableRequest withSubnetId(String subnetId) {
		setSubnetId(subnetId);
		return this;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public AssociateRouteTableRequest withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public AssociateRouteTableRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public AssociateRouteTableRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routeTableId=");
		builder.append(routeTableId);
		builder.append(", subnetId=");
		builder.append(subnetId);
		builder.append(", routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
