/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesRequest;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesResult;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * ルートテーブルカテゴリ クライアント。<br />
 * ルートテーブル カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyRouteTableClient extends BaseClient implements NiftyRouteTable {

	/**
	 * 認証情報を指定し、ルートテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyRouteTableClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、ルートテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyRouteTableClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#createRouteTable(com.nifty.cloud.sdk.routetable.model.CreateRouteTableRequest)
	 */
	@Override
	public CreateRouteTableResult createRouteTable(CreateRouteTableRequest request) {
		return (CreateRouteTableResult) client.execute(request, CreateRouteTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#deleteRouteTable(com.nifty.cloud.sdk.routetable.model.DeleteRouteTableRequest)
	 */
	@Override
	public DeleteRouteTableResult deleteRouteTable(DeleteRouteTableRequest request) {
		return (DeleteRouteTableResult) client.execute(request, DeleteRouteTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#describeRouteTables(com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesRequest)
	 */
	@Override
	public DescribeRouteTablesResult describeRouteTables(DescribeRouteTablesRequest request) {
		return (DescribeRouteTablesResult) client.execute(request, DescribeRouteTablesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#associateRouteTable(com.nifty.cloud.sdk.routetable.model.AssociateRouteTableRequest)
	 */
	@Override
	public AssociateRouteTableResult associateRouteTable(AssociateRouteTableRequest request) {
		return (AssociateRouteTableResult) client.execute(request, AssociateRouteTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#disassociateRouteTable(com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableRequest)
	 */
	@Override
	public DisassociateRouteTableResult disassociateRouteTable(DisassociateRouteTableRequest request) {
		return (DisassociateRouteTableResult) client.execute(request, DisassociateRouteTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#replaceRouteTableAssociation(com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationRequest)
	 */
	@Override
	public ReplaceRouteTableAssociationResult replaceRouteTableAssociation(ReplaceRouteTableAssociationRequest request) {
		return (ReplaceRouteTableAssociationResult) client.execute(request, ReplaceRouteTableAssociationResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#createRoute(com.nifty.cloud.sdk.routetable.model.CreateRouteRequest)
	 */
	@Override
	public CreateRouteResult createRoute(CreateRouteRequest request) {
		return (CreateRouteResult) client.execute(request, CreateRouteResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#deleteRoute(com.nifty.cloud.sdk.routetable.model.DeleteRouteRequest)
	 */
	@Override
	public DeleteRouteResult deleteRoute(DeleteRouteRequest request) {
		return (DeleteRouteResult) client.execute(request, DeleteRouteResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.routetable.NiftyRouteTable#replaceRoute(com.nifty.cloud.sdk.routetable.model.ReplaceRouteRequest)
	 */
	@Override
	public ReplaceRouteResult replaceRoute(ReplaceRouteRequest request) {
		return (ReplaceRouteResult) client.execute(request, ReplaceRouteResult.class);
	}
}