/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesRequest;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesResult;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * ルートテーブルカテゴリクライアント。<br />
 * ルートテーブル カテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyRouteTableAsync extends NiftyRouteTable {

	/**
	 * 非同期でルートテーブルを新規作成します。
	 *
	 * @param request CreateRouteTableリクエスト<br />
	 * &nbsp;	CreateRouteTableRequest#vpcIdは利用不可
	 * @return 非同期処理結果<br />
	 * &nbsp;	RouteTable#vpcIdは利用不可
	 */
	public Future<CreateRouteTableResult> createRouteTableAsync(CreateRouteTableRequest request);


	/**
	 * 非同期で指定したルートテーブルを削除します。
	 *
	 * @param request DeleteRouteTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteRouteTableResult> deleteRouteTableAsync(DeleteRouteTableRequest request);


	/**
	 * 非同期でルートテーブルの情報を取得します。
	 *
	 * @param request DescribeRouteTablesリクエスト
	 * @return 非同期処理結果<br />
	 * &nbsp;	RouteTableSet#vpcIdは利用不可<br />
	 * &nbsp;	Route#gatewayIdは利用不可<br />
	 * &nbsp;	Route#instanceIdは利用不可<br />
	 * &nbsp;	Route#instanceOwnerIdは利用不可<br />
	 * &nbsp;	Route#networkInterfaceIdは利用不可<br />
	 * &nbsp;	RouteTableAssociation#subnetIdは利用不可
	 */
	public Future<DescribeRouteTablesResult> describeRouteTablesAsync(DescribeRouteTablesRequest request);


	/**
	 * 非同期で指定したルートテーブルを指定したルーターに設定します。
	 *
	 * @param request AssociateRouteTableリクエスト<br />
	 * &nbsp;	AssociateRouteTableRequest#subnetIdは利用不可
	 * @return 非同期処理結果
	 */
	public Future<AssociateRouteTableResult> associateRouteTableAsync(AssociateRouteTableRequest request);


	/**
	 * 非同期で指定したルートテーブルをルーターから解除します。
	 *
	 * @param request DisassociateRouteTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DisassociateRouteTableResult> disassociateRouteTableAsync(DisassociateRouteTableRequest request);


	/**
	 * 非同期でルーターに適用されたルートテーブルを解除し、指定したルートテーブルに入れ替えます。
	 *
	 * @param request ReplaceRouteTableAssociationリクエスト
	 * @return 非同期処理結果
	 */
	public Future<ReplaceRouteTableAssociationResult> replaceRouteTableAssociationAsync(ReplaceRouteTableAssociationRequest request);


	/**
	 * 非同期でルートテーブルに適用するルート情報を新規作成します。
	 *
	 * @param request CreateRouteリクエスト<br />
	 * &nbsp;	CreateRouteRequest#gatewayIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#instanceIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#networkInterfaceIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#vpcPeeringConnectionIdは利用不可
	 * @return 非同期処理結果
	 */
	public Future<CreateRouteResult> createRouteAsync(CreateRouteRequest request);


	/**
	 * 非同期でルートテーブルに適用されたルート情報を削除します。
	 *
	 * @param request DeleteRouteリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteRouteResult> deleteRouteAsync(DeleteRouteRequest request);


	/**
	 * 非同期でルートテーブルに適用されたルート情報を削除し、指定したルート情報に入れ替えます。
	 *
	 * @param request ReplaceRouteリクエスト<br />
	 * &nbsp;	ReplaceRouteRequest#gatewayIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#instanceIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#networkInterfaceIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#vpcPeeringConnectionIdは利用不可
	 * @return 非同期処理結果
	 */
	public Future<ReplaceRouteResult> replaceRouteAsync(ReplaceRouteRequest request);

}