/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.routetable;


import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.AssociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteResult;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.CreateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteResult;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DeleteRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesRequest;
import com.nifty.cloud.sdk.routetable.model.DescribeRouteTablesResult;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableRequest;
import com.nifty.cloud.sdk.routetable.model.DisassociateRouteTableResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteResult;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationRequest;
import com.nifty.cloud.sdk.routetable.model.ReplaceRouteTableAssociationResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * ルートテーブル カテゴリ クライアント。<br />
 * ルートテーブル カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyRouteTable {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * ルートテーブルを新規作成します。
	 *
	 * @param request CreateRouteTableリクエスト<br />
	 * &nbsp;	CreateRouteTableRequest#vpcIdは利用不可
	 * @return CreateRouteTable処理結果<br />
	 * &nbsp;	RouteTable#vpcIdは利用不可
	 */
	public CreateRouteTableResult createRouteTable(CreateRouteTableRequest request);

	/**
	 * 指定したルートテーブルを削除します。
	 *
	 * @param request DeleteRouteTableリクエスト
	 * @return DeleteRouteTable処理結果
	 */
	public DeleteRouteTableResult deleteRouteTable(DeleteRouteTableRequest request);

	/**
	 * ルートテーブルの情報を取得します。
	 *
	 * @param request DescribeRouteTablesリクエスト
	 * @return DescribeRouteTables処理結果<br />
	 * &nbsp;	RouteTableSet#vpcIdは利用不可<br />
	 * &nbsp;	Route#gatewayIdは利用不可<br />
	 * &nbsp;	Route#instanceIdは利用不可<br />
	 * &nbsp;	Route#instanceOwnerIdは利用不可<br />
	 * &nbsp;	Route#networkInterfaceIdは利用不可<br />
	 * &nbsp;	RouteTableAssociation#subnetIdは利用不可
	 */
	public DescribeRouteTablesResult describeRouteTables(DescribeRouteTablesRequest request);

	/**
	 * 指定したルートテーブルを指定したルーターに設定します。
	 *
	 * @param request AssociateRouteTableリクエスト<br />
	 * &nbsp;	AssociateRouteTableRequest#subnetIdは利用不可
	 * @return AssociateRouteTable処理結果
	 */
	public AssociateRouteTableResult associateRouteTable(AssociateRouteTableRequest request);

	/**
	 * 指定したルートテーブルをルーターから解除します。
	 *
	 * @param request DisassociateRouteTableリクエスト
	 * @return DisassociateRouteTable処理結果
	 */
	public DisassociateRouteTableResult disassociateRouteTable(DisassociateRouteTableRequest request);

	/**
	 * ルーターに適用されたルートテーブルを解除し、指定したルートテーブルに入れ替えます。
	 *
	 * @param request ReplaceRouteTableAssociationリクエスト
	 * @return ReplaceRouteTableAssociation処理結果
	 */
	public ReplaceRouteTableAssociationResult replaceRouteTableAssociation(ReplaceRouteTableAssociationRequest request);

	/**
	 * ルートテーブルに適用するルート情報を新規作成します。
	 *
	 * @param request CreateRouteリクエスト<br />
	 * &nbsp;	CreateRouteRequest#gatewayIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#instanceIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#networkInterfaceIdは利用不可<br />
	 * &nbsp;	CreateRouteRequest#vpcPeeringConnectionIdは利用不可
	 * @return CreateRoute処理結果
	 */
	public CreateRouteResult createRoute(CreateRouteRequest request);

	/**
	 * ルートテーブルに適用されたルート情報を削除します。
	 *
	 * @param request DeleteRouteリクエスト
	 * @return DeleteRoute処理結果
	 */
	public DeleteRouteResult deleteRoute(DeleteRouteRequest request);

	/**
	 * ルートテーブルに適用されたルート情報を削除し、指定したルート情報に入れ替えます。
	 *
	 * @param request ReplaceRouteリクエスト<br />
	 * &nbsp;	ReplaceRouteRequest#gatewayIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#instanceIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#networkInterfaceIdは利用不可<br />
	 * &nbsp;	ReplaceRouteRequest#vpcPeeringConnectionIdは利用不可
	 * @return ReplaceRoute処理結果
	 */
	public ReplaceRouteResult replaceRoute(ReplaceRouteRequest request);
}