/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model.transform;

import com.nifty.cloud.sdk.router.model.NiftyCreateRouterResult;
import com.nifty.cloud.sdk.router.model.Router;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyCreateRouterResponseType変換クラス。<br />
 * このクラスはレスポンスXMLのNiftyCreateRouterResponse要素からNiftyCreateRouterResultクラスを生成します。
 */
public class NiftyCreateRouterResultConverter implements Converter {

	private static final String ELEMENT_REQUEST_ID = "requestId";
	private static final String ELEMENT_ROUTER = "router";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == NiftyCreateRouterResult.class;
	}

	/**
	 * {@literal
	 * NiftyCreateRouterResponseをNiftyCreateRouterResultクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal NiftyCreateRouterResultオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

		NiftyCreateRouterResult niftyCreateRouterResult = new NiftyCreateRouterResult();
		Converter routerConverter = new RouterConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_REQUEST_ID)) {
				niftyCreateRouterResult.setRequestId(reader.getValue());
			} else if (name.equals(ELEMENT_ROUTER)) {
				niftyCreateRouterResult.setRouter((Router) routerConverter.unmarshal(reader, context));
			}

			reader.moveUp();
		}

		return niftyCreateRouterResult;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
