/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.router.model.NetworkInterfaceSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NetworkInterfaceSetType変換クラス。<br />
 * このクラスはレスポンスXMLのnetworkInterfaceSet要素からNetworkInterfaceSetクラスのリストを生成します。
 */
public class NetworkInterfaceSetConverter implements Converter {

	private static final String ELEMENT_NETWORK_ID = "networkId";
	private static final String ELEMENT_NETWORK_NAME = "networkName";
	private static final String ELEMENT_DEVICE_INDEX = "deviceIndex";
	private static final String ELEMENT_IP_ADDRESS = "ipAddress";
	private static final String ELEMENT_CIDR_BLOCK = "cidrBlock";
	private static final String ELEMENT_DHCP = "dhcp";
	private static final String ELEMENT_DHCP_OPTIONS_ID = "dhcpOptionsId";
	private static final String ELEMENT_DHCP_CONFIG_ID = "dhcpConfigId";
	private static final String ELEMENT_DESCRIPTION = "description";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;

	}

	/**
	 * {@literal
	 * networkInterfaceSetをList<NetworkInterfaceSet>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<NetworkInterfaceSet>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<NetworkInterfaceSet> networkInterfaceSets = new ArrayList<NetworkInterfaceSet>();
		
		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();	
			NetworkInterfaceSet networkInterfaceSet = new NetworkInterfaceSet();
			
			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_NETWORK_ID)) {
					networkInterfaceSet.setNetworkId(reader.getValue());
				} else if (name.equals(ELEMENT_NETWORK_NAME)) {
					networkInterfaceSet.setNetworkName(reader.getValue());
				} else if (name.equals(ELEMENT_DEVICE_INDEX)) {
					networkInterfaceSet.setDeviceIndex(new Integer(reader.getValue()));
				} else if (name.equals(ELEMENT_IP_ADDRESS)) {
					networkInterfaceSet.setIpAddress(reader.getValue());
				} else if (name.equals(ELEMENT_CIDR_BLOCK)) {
					networkInterfaceSet.setCidrBlock(reader.getValue());
				} else if (name.equals(ELEMENT_DHCP)) {
					networkInterfaceSet.setDhcp(Boolean.valueOf(reader.getValue()));
				} else if (name.equals(ELEMENT_DHCP_OPTIONS_ID)) {
					networkInterfaceSet.setDhcpOptionsId(reader.getValue());
				} else if (name.equals(ELEMENT_DHCP_CONFIG_ID)) {
					networkInterfaceSet.setDhcpConfigId(reader.getValue());
				} else if (name.equals(ELEMENT_DESCRIPTION)) {
					networkInterfaceSet.setDescription(reader.getValue());
				}
	
				reader.moveUp();
			}
			
			networkInterfaceSets.add(networkInterfaceSet);
			reader.moveUp();
		}

		return networkInterfaceSets;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
