/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * ルーター情報クラス。<br />
 * このクラスはルーター情報を格納します。
 *
 */
public class Router {

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/** ルーターステータス */
	private String state;

	/** ゾーン名 */
	private String availabilityZone;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/** 利用料金タイプ */
	private String accountingType;

	/** 翌月の利用料金タイプ */
	private String nextMonthAccountingType;

	/** ルーターのメモ */
	private String description;

	/** ルーターのversion情報 */
	private VersionInformation versionInformation;

	/** ネットワークインターフェイス情報 */
	private List<NetworkInterfaceSet> networkInterfaces;

	/** ルートテーブルID */
	private String routeTableId;

	/** ルートテーブル適用ID */
	private String routeTableAssociationId;

	/** NATテーブルID */
	private String natTableId;

	/** NATテーブル適用ID */
	private String natTableAssociationId;

	/** バックアップ情報 */
	private BackupInformation backupInformation;

	/** ルーターのタイプ */
	private String type;

	/** ファイアウォールグループ名リスト */
	private List<String> groupIds;

	/** 作成日時 */
	private Date createdTime;

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public Router withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public Router withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * ルーターステータスを取得します。
	 *
	 * @return ルーターステータス
	 */
	public String getState() {
		return state;
	}

	/**
	 * ルーターステータスを設定します。
	 *
	 * @param state ルーターステータス
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * ルーターステータスを設定し、自オブジェクトを返します。
	 *
	 * @param state ルーターステータス
	 * @return 自オブジェクト
	 */
	public Router withState(String state) {
		setState(state);
		return this;
	}

	/**
	 * ゾーン名を取得します。
	 *
	 * @return ゾーン名
	 */
	public String getAvailabilityZone() {
		return availabilityZone;
	}

	/**
	 * ゾーン名を設定します。
	 *
	 * @param availabilityZone ゾーン名
	 */
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}

	/**
	 * ゾーン名を設定し、自オブジェクトを返します。
	 *
	 * @param availabilityZone ゾーン名
	 * @return 自オブジェクト
	 */
	public Router withAvailabilityZone(String availabilityZone) {
		setAvailabilityZone(availabilityZone);
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public Router withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public Router withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/**
	 * 利用料金タイプを取得します。
	 *
	 * @return 利用料金タイプ
	 */
	public String getAccountingType() {
		return accountingType;
	}

	/**
	 * 利用料金タイプを設定します。
	 *
	 * @param accountingType 利用料金タイプ
	 */
	public void setAccountingType(String accountingType) {
		this.accountingType = accountingType;
	}

	/**
	 * 利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param accountingType 利用料金タイプ
	 * @return 自オブジェクト
	 */
	public Router withAccountingType(String accountingType) {
		setAccountingType(accountingType);
		return this;
	}

	/**
	 * 翌月の利用料金タイプを取得します。
	 *
	 * @return 翌月の利用料金タイプ
	 */
	public String getNextMonthAccountingType() {
		return nextMonthAccountingType;
	}

	/**
	 * 翌月の利用料金タイプを設定します。
	 *
	 * @param nextMonthAccountingType 翌月の利用料金タイプ
	 */
	public void setNextMonthAccountingType(String nextMonthAccountingType) {
		this.nextMonthAccountingType = nextMonthAccountingType;
	}

	/**
	 * 翌月の利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param nextMonthAccountingType 翌月の利用料金タイプ
	 * @return 自オブジェクト
	 */
	public Router withNextMonthAccountingType(String nextMonthAccountingType) {
		setNextMonthAccountingType(nextMonthAccountingType);
		return this;
	}

	/**
	 * ルーターのメモを取得します。
	 *
	 * @return ルーターのメモ
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * ルーターのメモを設定します。
	 *
	 * @param description ルーターのメモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * ルーターのメモを設定し、自オブジェクトを返します。
	 *
	 * @param description ルーターのメモ
	 * @return 自オブジェクト
	 */
	public Router withDescription(String description) {
		setDescription(description);
		return this;
	}

	/**
	 * ルーターのversion情報を取得します。
	 *
	 * @return ルーターのversion情報
	 */
	public VersionInformation getVersionInformation() {
		return versionInformation;
	}

	/**
	 * ルーターのversion情報を設定します。
	 *
	 * @param versionInformation ルーターのversion情報
	 */
	public void setVersionInformation(VersionInformation versionInformation) {
		this.versionInformation = versionInformation;
	}

	/**
	 * ルーターのversion情報を設定し、自オブジェクトを返します。
	 *
	 * @param versionInformation ルーターのversion情報
	 * @return 自オブジェクト
	 */
	public Router withVersionInformation(VersionInformation versionInformation) {
		setVersionInformation(versionInformation);
		return this;
	}

	/**
	 * ネットワークインターフェイス情報を取得します。
	 *
	 * @return ネットワークインターフェイス情報
	 */
	public List<NetworkInterfaceSet> getNetworkInterfaces() {
		return networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報を設定します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報
	 */
	public void setNetworkInterfaces(List<NetworkInterfaceSet> networkInterfaces) {
		this.networkInterfaces = networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報の配列
	 * @return 自オブジェクト
	 */
	public Router withNetworkInterfaces(NetworkInterfaceSet ... networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterfaceSet>();
		for (NetworkInterfaceSet networkInterface : networkInterfaces) {
			getNetworkInterfaces().add(networkInterface);
		}
		return this;
	}

	/**
	 * ネットワークインターフェイス情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報リスト
	 * @return 自オブジェクト
	 */
	public Router withNetworkInterfaces(Collection<NetworkInterfaceSet> networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterfaceSet>();
		if (networkInterfaces != null) {
			getNetworkInterfaces().addAll(networkInterfaces);
		}
		return this;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public Router withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	public String getRouteTableAssociationId() {
		return routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 */
	public void setRouteTableAssociationId(String routeTableAssociationId) {
		this.routeTableAssociationId = routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public Router withRouteTableAssociationId(String routeTableAssociationId) {
		setRouteTableAssociationId(routeTableAssociationId);
		return this;
	}

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public Router withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * NATテーブル適用IDを取得します。
	 *
	 * @return NATテーブル適用ID
	 */
	public String getNatTableAssociationId() {
		return natTableAssociationId;
	}

	/**
	 * NATテーブル適用IDを設定します。
	 *
	 * @param natTableAssociationId NATテーブル適用ID
	 */
	public void setNatTableAssociationId(String natTableAssociationId) {
		this.natTableAssociationId = natTableAssociationId;
	}

	/**
	 * NATテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableAssociationId NATテーブル適用ID
	 * @return 自オブジェクト
	 */
	public Router withNatTableAssociationId(String natTableAssociationId) {
		setNatTableAssociationId(natTableAssociationId);
		return this;
	}

	/**
	 * バックアップ情報を取得します。
	 *
	 * @return バックアップ情報
	 */
	public BackupInformation getBackupInformation() {
		return backupInformation;
	}

	/**
	 * バックアップ情報を設定します。
	 *
	 * @param backupInformation バックアップ情報
	 */
	public void setBackupInformation(BackupInformation backupInformation) {
		this.backupInformation = backupInformation;
	}

	/**
	 * バックアップ情報を設定し、自オブジェクトを返します。
	 *
	 * @param backupInformation バックアップ情報
	 * @return 自オブジェクト
	 */
	public Router withBackupInformation(BackupInformation backupInformation) {
		setBackupInformation(backupInformation);
		return this;
	}

	/**
	 * ルーターのタイプを取得します。
	 *
	 * @return ルーターのタイプ
	 */
	public String getType() {
		return type;
	}

	/**
	 * ルーターのタイプを設定します。
	 *
	 * @param type ルーターのタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * ルーターのタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type ルーターのタイプ
	 * @return 自オブジェクト
	 */
	public Router withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを取得します。
	 *
	 * @return ファイアウォールグループ名リスト
	 */
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * ファイアウォールグループ名リストを設定します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名の配列
	 * @return 自オブジェクト
	 */
	public Router withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 * @return 自オブジェクト
	 */
	public Router withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/**
	 * 作成日時を取得します。
	 *
	 * @return 作成日時
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * 作成日時を設定します。
	 *
	 * @param createdTime 作成日時
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * 作成日時を設定し、自オブジェクトを返します。
	 *
	 * @param createdTime 作成日時
	 * @return 自オブジェクト
	 */
	public Router withCreatedTime(Date createdTime) {
		setCreatedTime(createdTime);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", state=");
		builder.append(state);
		builder.append(", availabilityZone=");
		builder.append(availabilityZone);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append(", accountingType=");
		builder.append(accountingType);
		builder.append(", nextMonthAccountingType=");
		builder.append(nextMonthAccountingType);
		builder.append(", description=");
		builder.append(description);
		builder.append(", versionInformation=");
		builder.append(versionInformation);
		builder.append(", networkInterfaces=");
		builder.append(networkInterfaces);
		builder.append(", routeTableId=");
		builder.append(routeTableId);
		builder.append(", routeTableAssociationId=");
		builder.append(routeTableAssociationId);
		builder.append(", natTableId=");
		builder.append(natTableId);
		builder.append(", natTableAssociationId=");
		builder.append(natTableAssociationId);
		builder.append(", backupInformation=");
		builder.append(backupInformation);
		builder.append(", type=");
		builder.append(type);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append(", createdTime=");
		builder.append(createdTime);
		builder.append("]");
		return builder.toString();
	}
}
