/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRebootRoutersリクエストクラス。<br />
 * このクラスはNiftyRebootRoutersへのリクエストを構築します。
 *
 */
@Action("NiftyRebootRouters")
public class NiftyRebootRoutersRequest implements Request {

	/** ルーター情報リスト */
	private List<NiftyRebootRouter> niftyRebootRouters;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyRebootRoutersRequest() {
	}

	/**
	 * ルーター情報リストを指定し、NiftyRebootRoutersRequestを構築します。
	 *
	 * @param niftyRebootRouters ルーター情報リスト
	 */
	public NiftyRebootRoutersRequest(List<NiftyRebootRouter> niftyRebootRouters) {
		this.niftyRebootRouters = niftyRebootRouters;
	}

	/**
	 * ルーター情報リストを取得します。
	 *
	 * @return ルーター情報リスト
	 */
	@Query(name="Router", require=true)
	public List<NiftyRebootRouter> getNiftyRebootRouters() {
		return niftyRebootRouters;
	}

	/**
	 * ルーター情報リストを設定します。
	 *
	 * @param niftyRebootRouters ルーター情報リスト
	 */
	public void setNiftyRebootRouters(List<NiftyRebootRouter> niftyRebootRouters) {
		this.niftyRebootRouters = niftyRebootRouters;
	}

	/**
	 * ルーター情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param niftyRebootRouters ルーター情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyRebootRoutersRequest withNiftyRebootRouters(NiftyRebootRouter ... niftyRebootRouters) {
		if (this.niftyRebootRouters == null) this.niftyRebootRouters = new ArrayList<NiftyRebootRouter>();
		for (NiftyRebootRouter niftyRebootRouter : niftyRebootRouters) {
			getNiftyRebootRouters().add(niftyRebootRouter);
		}
		return this;
	}

	/**
	 * ルーター情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param niftyRebootRouters ルーター情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyRebootRoutersRequest withNiftyRebootRouters(Collection<NiftyRebootRouter> niftyRebootRouters) {
		if (this.niftyRebootRouters == null) this.niftyRebootRouters = new ArrayList<NiftyRebootRouter>();
		if (niftyRebootRouters != null) {
			getNiftyRebootRouters().addAll(niftyRebootRouters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[niftyRebootRouters=");
		builder.append(niftyRebootRouters);
		builder.append("]");
		return builder.toString();
	}
}
