/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ルーター再起動情報クラス。<br />
 * このクラスはルーター再起動情報を格納します。
 *
 */
public class NiftyRebootRouter {

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/** 再起動オプション */
	private String niftyReboot;

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyRebootRouter withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public NiftyRebootRouter withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * 再起動オプションを取得します。
	 *
	 * @return 再起動オプション
	 */
	@Query(name="NiftyReboot")
	public String getNiftyReboot() {
		return niftyReboot;
	}

	/**
	 * 再起動オプションを設定します。
	 *
	 * @param niftyReboot 再起動オプション
	 */
	public void setNiftyReboot(String niftyReboot) {
		this.niftyReboot = niftyReboot;
	}

	/**
	 * 再起動オプションを設定し、自オブジェクトを返します。
	 *
	 * @param niftyReboot 再起動オプション
	 * @return 自オブジェクト
	 */
	public NiftyRebootRouter withNiftyReboot(String niftyReboot) {
		setNiftyReboot(niftyReboot);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", niftyReboot=");
		builder.append(niftyReboot);
		builder.append("]");
		return builder.toString();
	}
}
