/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.router.model.transform.NiftyDescribeRoutersResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeRouters処理結果クラス。<br />
 * このクラスはNiftyDescribeRoutersのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeRoutersResponse")
@XStreamConverter(NiftyDescribeRoutersResultConverter.class)
public class NiftyDescribeRoutersResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** ルーター情報リスト */
	private List<Router> routers;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDescribeRoutersResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * ルーター情報リストを取得します。
	 *
	 * @return ルーター情報リスト
	 */
	public List<Router> getRouters() {
		return routers;
	}

	/**
	 * ルーター情報リストを設定します。
	 *
	 * @param routers ルーター情報リスト
	 */
	public void setRouters(List<Router> routers) {
		this.routers = routers;
	}

	/**
	 * ルーター情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param routers ルーター情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeRoutersResult withRouters(Router ... routers) {
		if (this.routers == null) this.routers = new ArrayList<Router>();
		for (Router router : routers) {
			getRouters().add(router);
		}
		return this;
	}

	/**
	 * ルーター情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param routers ルーター情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeRoutersResult withRouters(Collection<Router> routers) {
		if (this.routers == null) this.routers = new ArrayList<Router>();
		if (routers != null) {
			getRouters().addAll(routers);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", routers=");
		builder.append(routers);
		builder.append("]");
		return builder.toString();
	}
}
