/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreateRouterリクエストクラス。<br />
 * このクラスはNiftyCreateRouterへのリクエストを構築します。
 *
 */
@Action("NiftyCreateRouter")
public class NiftyCreateRouterRequest implements Request {

	/** ルーター名 */
	private String routerName;

	/** ゾーン名 */
	private String availabilityZone;

	/** 利用料金タイプ */
	private String accountingType;

	/** メモ */
	private String description;

	/** ルーターのタイプ */
	private String type;

	/** ネットワークインターフェイス情報リスト */
	private List<NetworkInterface> networkInterfaces;

	/** ファイアウォールグループ名リスト */
	private List<String> groupIds;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyCreateRouterRequest() {
	}

	/**
	 * ネットワークインターフェイス情報リストを指定し、NiftyCreateRouterRequestを構築します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報リスト
	 */
	public NiftyCreateRouterRequest(List<NetworkInterface> networkInterfaces) {
		this.networkInterfaces = networkInterfaces;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * ゾーン名を取得します。
	 *
	 * @return ゾーン名
	 */
	@Query(name="AvailabilityZone")
	public String getAvailabilityZone() {
		return availabilityZone;
	}

	/**
	 * ゾーン名を設定します。
	 *
	 * @param availabilityZone ゾーン名
	 */
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}

	/**
	 * ゾーン名を設定し、自オブジェクトを返します。
	 *
	 * @param availabilityZone ゾーン名
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withAvailabilityZone(String availabilityZone) {
		setAvailabilityZone(availabilityZone);
		return this;
	}

	/**
	 * 利用料金タイプを取得します。
	 *
	 * @return 利用料金タイプ
	 */
	@Query(name="AccountingType")
	public String getAccountingType() {
		return accountingType;
	}

	/**
	 * 利用料金タイプを設定します。
	 *
	 * @param accountingType 利用料金タイプ
	 */
	public void setAccountingType(String accountingType) {
		this.accountingType = accountingType;
	}

	/**
	 * 利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param accountingType 利用料金タイプ
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withAccountingType(String accountingType) {
		setAccountingType(accountingType);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="Description")
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withDescription(String description) {
		setDescription(description);
		return this;
	}

	/**
	 * ルーターのタイプを取得します。
	 *
	 * @return ルーターのタイプ
	 */
	@Query(name="Type")
	public String getType() {
		return type;
	}

	/**
	 * ルーターのタイプを設定します。
	 *
	 * @param type ルーターのタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * ルーターのタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type ルーターのタイプ
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * ネットワークインターフェイス情報リストを取得します。
	 *
	 * @return ネットワークインターフェイス情報リスト
	 */
	@Query(name="NetworkInterface", require=true)
	public List<NetworkInterface> getNetworkInterfaces() {
		return networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報リストを設定します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報リスト
	 */
	public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
		this.networkInterfaces = networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterface>();
		for (NetworkInterface networkInterface : networkInterfaces) {
			getNetworkInterfaces().add(networkInterface);
		}
		return this;
	}

	/**
	 * ネットワークインターフェイス情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterface>();
		if (networkInterfaces != null) {
			getNetworkInterfaces().addAll(networkInterfaces);
		}
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを取得します。
	 *
	 * @return ファイアウォールグループ名リスト
	 */
	@Query(name="SecurityGroup")
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * ファイアウォールグループ名リストを設定します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名の配列
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 * @return 自オブジェクト
	 */
	public NiftyCreateRouterRequest withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerName=");
		builder.append(routerName);
		builder.append(", availabilityZone=");
		builder.append(availabilityZone);
		builder.append(", accountingType=");
		builder.append(accountingType);
		builder.append(", description=");
		builder.append(description);
		builder.append(", type=");
		builder.append(type);
		builder.append(", networkInterfaces=");
		builder.append(networkInterfaces);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append("]");
		return builder.toString();
	}
}
