/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

/**
 * ネットワークインターフェイス情報セットクラス。<br />
 * このクラスはネットワークインターフェイス情報セットを格納します。
 *
 */
public class NetworkInterfaceSet {

	/** ネットワークユニークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/** デバイス番号 */
	private Integer deviceIndex;

	/** IPアドレス */
	private String ipAddress;

	/** ネットワークのCIDR */
	private String cidrBlock;

	/** dhcp設定フラグ */
	private Boolean dhcp;

	/** dhcpオプションID */
	private String dhcpOptionsId;

	/** dhcpコンフィグID */
	private String dhcpConfigId;

	/** ネットワークのメモ */
	private String description;

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param networkName ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * デバイス番号を取得します。
	 *
	 * @return デバイス番号
	 */
	public Integer getDeviceIndex() {
		return deviceIndex;
	}

	/**
	 * デバイス番号を設定します。
	 *
	 * @param deviceIndex デバイス番号
	 */
	public void setDeviceIndex(Integer deviceIndex) {
		this.deviceIndex = deviceIndex;
	}

	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex デバイス番号
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * ネットワークのCIDRを取得します。
	 *
	 * @return ネットワークのCIDR
	 */
	public String getCidrBlock() {
		return cidrBlock;
	}

	/**
	 * ネットワークのCIDRを設定します。
	 *
	 * @param cidrBlock ネットワークのCIDR
	 */
	public void setCidrBlock(String cidrBlock) {
		this.cidrBlock = cidrBlock;
	}

	/**
	 * ネットワークのCIDRを設定し、自オブジェクトを返します。
	 *
	 * @param cidrBlock ネットワークのCIDR
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withCidrBlock(String cidrBlock) {
		setCidrBlock(cidrBlock);
		return this;
	}

	/**
	 * dhcp設定フラグを取得します。
	 *
	 * @return dhcp設定フラグ
	 */
	public Boolean getDhcp() {
		return dhcp;
	}

	/**
	 * dhcp設定フラグを設定します。
	 *
	 * @param dhcp dhcp設定フラグ
	 */
	public void setDhcp(Boolean dhcp) {
		this.dhcp = dhcp;
	}

	/**
	 * dhcp設定フラグを設定し、自オブジェクトを返します。
	 *
	 * @param dhcp dhcp設定フラグ
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDhcp(Boolean dhcp) {
		setDhcp(dhcp);
		return this;
	}

	/**
	 * dhcpオプションIDを取得します。
	 *
	 * @return dhcpオプションID
	 */
	public String getDhcpOptionsId() {
		return dhcpOptionsId;
	}

	/**
	 * dhcpオプションIDを設定します。
	 *
	 * @param dhcpOptionsId dhcpオプションID
	 */
	public void setDhcpOptionsId(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * dhcpオプションIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsId dhcpオプションID
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDhcpOptionsId(String dhcpOptionsId) {
		setDhcpOptionsId(dhcpOptionsId);
		return this;
	}

	/**
	 * dhcpコンフィグIDを取得します。
	 *
	 * @return dhcpコンフィグID
	 */
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * dhcpコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId dhcpコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * dhcpコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId dhcpコンフィグID
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/**
	 * ネットワークのメモを取得します。
	 *
	 * @return ネットワークのメモ
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * ネットワークのメモを設定します。
	 *
	 * @param description ネットワークのメモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * ネットワークのメモを設定し、自オブジェクトを返します。
	 *
	 * @param description ネットワークのメモ
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", cidrBlock=");
		builder.append(cidrBlock);
		builder.append(", dhcp=");
		builder.append(dhcp);
		builder.append(", dhcpOptionsId=");
		builder.append(dhcpOptionsId);
		builder.append(", dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
