/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ネットワークインターフェイス情報クラス。<br />
 * このクラスはネットワークインターフェイス情報を格納します。
 *
 */
public class NetworkInterface {

	private Integer deviceIndex;

	private List<String> groupIds;

	/** ネットワークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/** IPアドレス */
	private String ipAddress;

	/** dhcp設定フラグ */
	private Boolean dhcp;

	/** dhcpオプションID */
	private String dhcpOptionsId;

	/** dhcpコンフィグID */
	private String dhcpConfigId;

	/**
	 * deviceIndexを取得します。
	 *
	 * @return deviceIndex
	 */
	@Query(name="DeviceIndex")
	public Integer getDeviceIndex() {
		return deviceIndex;
	}

	/**
	 * deviceIndexを設定します。
	 *
	 * @param deviceIndex
	 */
	public void setDeviceIndex(Integer deviceIndex) {
		this.deviceIndex = deviceIndex;
	}

	/**
	 * deviceIndexを設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * groupIdsを取得します。
	 *
	 * @return groupIds
	 */
	@Query(name="SecurityGroupId")
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * groupIdsを設定します。
	 *
	 * @param groupIds
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * groupIdsの配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds
	 * @return 自オブジェクト
	 */
	public NetworkInterface withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * groupIdsリストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds
	 * @return 自オブジェクト
	 */
	public NetworkInterface withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/**
	 * ネットワークIDを取得します。
	 *
	 * @return ネットワークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークIDを設定します。
	 *
	 * @param networkId ネットワークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークID
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param networkName ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	@Query(name="IpAddress")
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public NetworkInterface withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * dhcp設定フラグを取得します。
	 *
	 * @return dhcp設定フラグ
	 */
	@Query(name="Dhcp")
	public Boolean getDhcp() {
		return dhcp;
	}

	/**
	 * dhcp設定フラグを設定します。
	 *
	 * @param dhcp dhcp設定フラグ
	 */
	public void setDhcp(Boolean dhcp) {
		this.dhcp = dhcp;
	}

	/**
	 * dhcp設定フラグを設定し、自オブジェクトを返します。
	 *
	 * @param dhcp dhcp設定フラグ
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDhcp(Boolean dhcp) {
		setDhcp(dhcp);
		return this;
	}

	/**
	 * dhcpオプションIDを取得します。
	 *
	 * @return dhcpオプションID
	 */
	@Query(name="DhcpOptionsId")
	public String getDhcpOptionsId() {
		return dhcpOptionsId;
	}

	/**
	 * dhcpオプションIDを設定します。
	 *
	 * @param dhcpOptionsId dhcpオプションID
	 */
	public void setDhcpOptionsId(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * dhcpオプションIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsId dhcpオプションID
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDhcpOptionsId(String dhcpOptionsId) {
		setDhcpOptionsId(dhcpOptionsId);
		return this;
	}

	/**
	 * dhcpコンフィグIDを取得します。
	 *
	 * @return dhcpコンフィグID
	 */
	@Query(name="DhcpConfigId")
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * dhcpコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId dhcpコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * dhcpコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId dhcpコンフィグID
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", dhcp=");
		builder.append(dhcp);
		builder.append(", dhcpOptionsId=");
		builder.append(dhcpOptionsId);
		builder.append(", dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append("]");
		return builder.toString();
	}
}
