/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router.model;

import java.util.Date;

/**
 * バックアップ情報クラス。<br />
 * このクラスはバックアップ情報を格納します。
 *
 */
public class BackupInformation {

	/** バックアップが存在するか */
	private Boolean isBackup;

	/** バックアップの保持期限 */
	private Date expirationDate;

	/**
	 * バックアップが存在するかを取得します。
	 *
	 * @return バックアップが存在するか
	 */
	public Boolean getIsBackup() {
		return isBackup;
	}

	/**
	 * バックアップが存在するかを設定します。
	 *
	 * @param isBackup バックアップが存在するか
	 */
	public void setIsBackup(Boolean isBackup) {
		this.isBackup = isBackup;
	}

	/**
	 * バックアップが存在するかを設定し、自オブジェクトを返します。
	 *
	 * @param isBackup バックアップが存在するか
	 * @return 自オブジェクト
	 */
	public BackupInformation withIsBackup(Boolean isBackup) {
		setIsBackup(isBackup);
		return this;
	}

	/**
	 * バックアップの保持期限を取得します。
	 *
	 * @return バックアップの保持期限
	 */
	public Date getExpirationDate() {
		return expirationDate;
	}

	/**
	 * バックアップの保持期限を設定します。
	 *
	 * @param expirationDate バックアップの保持期限
	 */
	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}

	/**
	 * バックアップの保持期限を設定し、自オブジェクトを返します。
	 *
	 * @param expirationDate バックアップの保持期限
	 * @return 自オブジェクト
	 */
	public BackupInformation withExpirationDate(Date expirationDate) {
		setExpirationDate(expirationDate);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[isBackup=");
		builder.append(isBackup);
		builder.append(", expirationDate=");
		builder.append(expirationDate);
		builder.append("]");
		return builder.toString();
	}
}
