/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.router.model.NiftyCreateRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyCreateRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeRequest;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeResult;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateRequest;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateResult;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesRequest;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * ルーターカテゴリ クライアント。<br />
 * ルーター カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public class NiftyRouterClient extends BaseClient implements NiftyRouter {

	/**
	 * 認証情報を指定し、ルーターカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyRouterClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、ルーターカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyRouterClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyCreateRouter(com.nifty.cloud.sdk.router.model.NiftyCreateRouterRequest)
	 */
	@Override
	public NiftyCreateRouterResult niftyCreateRouter(NiftyCreateRouterRequest request) {
		return (NiftyCreateRouterResult) client.execute(request, NiftyCreateRouterResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyDeleteRouter(com.nifty.cloud.sdk.router.model.NiftyDeleteRouterRequest)
	 */
	@Override
	public NiftyDeleteRouterResult niftyDeleteRouter(NiftyDeleteRouterRequest request) {
		return (NiftyDeleteRouterResult) client.execute(request, NiftyDeleteRouterResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyDescribeRouters(com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersRequest)
	 */
	@Override
	public NiftyDescribeRoutersResult niftyDescribeRouters(NiftyDescribeRoutersRequest request) {
		return (NiftyDescribeRoutersResult) client.execute(request, NiftyDescribeRoutersResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyRebootRouters(com.nifty.cloud.sdk.router.model.NiftyRebootRoutersRequest)
	 */
	@Override
	public NiftyRebootRoutersResult niftyRebootRouters(NiftyRebootRoutersRequest request) {
		return (NiftyRebootRoutersResult) client.execute(request, NiftyRebootRoutersResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyModifyRouterAttribute(com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeRequest)
	 */
	@Override
	public NiftyModifyRouterAttributeResult niftyModifyRouterAttribute(NiftyModifyRouterAttributeRequest request) {
		return (NiftyModifyRouterAttributeResult) client.execute(request, NiftyModifyRouterAttributeResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyUpdateRouterNetworkInterfaces(com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesRequest)
	 */
	@Override
	public NiftyUpdateRouterNetworkInterfacesResult niftyUpdateRouterNetworkInterfaces(NiftyUpdateRouterNetworkInterfacesRequest request) {
		return (NiftyUpdateRouterNetworkInterfacesResult) client.execute(request, NiftyUpdateRouterNetworkInterfacesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyReplaceRouterLatestVersion(com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionRequest)
	 */
	@Override
	public NiftyReplaceRouterLatestVersionResult niftyReplaceRouterLatestVersion(NiftyReplaceRouterLatestVersionRequest request) {
		return (NiftyReplaceRouterLatestVersionResult) client.execute(request, NiftyReplaceRouterLatestVersionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyRestoreRouterPreviousVersion(com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionRequest)
	 */
	@Override
	public NiftyRestoreRouterPreviousVersionResult niftyRestoreRouterPreviousVersion(NiftyRestoreRouterPreviousVersionRequest request) {
		return (NiftyRestoreRouterPreviousVersionResult) client.execute(request, NiftyRestoreRouterPreviousVersionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.router.NiftyRouter#niftyReleaseRouterBackupState(com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateRequest)
	 */
	@Override
	public NiftyReleaseRouterBackupStateResult niftyReleaseRouterBackupState(NiftyReleaseRouterBackupStateRequest request) {
		return (NiftyReleaseRouterBackupStateResult) client.execute(request, NiftyReleaseRouterBackupStateResult.class);
	}
}