/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.router.model.NiftyCreateRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyCreateRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeRequest;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeResult;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateRequest;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateResult;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesRequest;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * ルーターカテゴリクライアント。<br />
 * ルーター カテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftyRouterAsync extends NiftyRouter {

	/**
	 * 非同期でルーターを新規作成します。
	 *
	 * @param request NiftyCreateRouterリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateRouterResult> niftyCreateRouterAsync(NiftyCreateRouterRequest request);


	/**
	 * 非同期で指定したルーターを削除します。
	 *
	 * @param request NiftyDeleteRouterリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteRouterResult> niftyDeleteRouterAsync(NiftyDeleteRouterRequest request);


	/**
	 * 非同期でルーターの情報を取得します。
	 *
	 * @param request NiftyDescribeRoutersリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeRoutersResult> niftyDescribeRoutersAsync(NiftyDescribeRoutersRequest request);


	/**
	 * 非同期で指定したルーターを再起動します。
	 *
	 * @param request NiftyRebootRoutersリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyRebootRoutersResult> niftyRebootRoutersAsync(NiftyRebootRoutersRequest request);


	/**
	 * 非同期で指定したルーターの詳細情報を更新します。
	 *
	 * @param request NiftyModifyRouterAttributeリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyModifyRouterAttributeResult> niftyModifyRouterAttributeAsync(NiftyModifyRouterAttributeRequest request);


	/**
	 * 非同期で指定したルーターのネットワーク設定を変更します。
	 *
	 * @param request NiftyUpdateRouterNetworkInterfacesリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可
	 * @return 非同期処理結果
	 */
	public Future<NiftyUpdateRouterNetworkInterfacesResult> niftyUpdateRouterNetworkInterfacesAsync(NiftyUpdateRouterNetworkInterfacesRequest request);


	/**
	 * 非同期で指定したルーターを最新のバージョンにします。
	 *
	 * @param request NiftyReplaceRouterLatestVersionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceRouterLatestVersionResult> niftyReplaceRouterLatestVersionAsync(NiftyReplaceRouterLatestVersionRequest request);


	/**
	 * 非同期で指定したルーターの旧バージョンへの復元を実施します。
	 *
	 * @param request NiftyRestoreRouterPreviousVersionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyRestoreRouterPreviousVersionResult> niftyRestoreRouterPreviousVersionAsync(NiftyRestoreRouterPreviousVersionRequest request);


	/**
	 * 非同期で指定したルーターのバックアップ状態を解除します。
	 *
	 * @param request NiftyReleaseRouterBackupStateリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReleaseRouterBackupStateResult> niftyReleaseRouterBackupStateAsync(NiftyReleaseRouterBackupStateRequest request);

}