/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.router;

import com.nifty.cloud.sdk.router.model.NiftyCreateRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyCreateRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterRequest;
import com.nifty.cloud.sdk.router.model.NiftyDeleteRouterResult;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeRequest;
import com.nifty.cloud.sdk.router.model.NiftyModifyRouterAttributeResult;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyRebootRoutersResult;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateRequest;
import com.nifty.cloud.sdk.router.model.NiftyReleaseRouterBackupStateResult;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyReplaceRouterLatestVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionRequest;
import com.nifty.cloud.sdk.router.model.NiftyRestoreRouterPreviousVersionResult;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesRequest;
import com.nifty.cloud.sdk.router.model.NiftyUpdateRouterNetworkInterfacesResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * ルーター カテゴリ クライアント。<br />
 * ルーター カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftyRouter {
	
	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * ルーターを新規作成します。
	 *
	 * @param request NiftyCreateRouterリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可
	 * @return NiftyCreateRouter処理結果
	 */
	public NiftyCreateRouterResult niftyCreateRouter(NiftyCreateRouterRequest request);

	/**
	 * 指定したルーターを削除します。
	 *
	 * @param request NiftyDeleteRouterリクエスト
	 * @return NiftyDeleteRouter処理結果
	 */
	public NiftyDeleteRouterResult niftyDeleteRouter(NiftyDeleteRouterRequest request);

	/**
	 * ルーターの情報を取得します。
	 *
	 * @param request NiftyDescribeRoutersリクエスト
	 * @return NiftyDescribeRouters処理結果
	 */
	public NiftyDescribeRoutersResult niftyDescribeRouters(NiftyDescribeRoutersRequest request);

	/**
	 * 指定したルーターを再起動します。
	 *
	 * @param request NiftyRebootRoutersリクエスト
	 * @return NiftyRebootRouters処理結果
	 */
	public NiftyRebootRoutersResult niftyRebootRouters(NiftyRebootRoutersRequest request);

	/**
	 * 指定したルーターの詳細情報を更新します。
	 *
	 * @param request NiftyModifyRouterAttributeリクエスト
	 * @return NiftyModifyRouterAttribute処理結果
	 */
	public NiftyModifyRouterAttributeResult niftyModifyRouterAttribute(NiftyModifyRouterAttributeRequest request);

	/**
	 * 指定したルーターのネットワーク設定を変更します。
	 *
	 * @param request NiftyUpdateRouterNetworkInterfacesリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可
	 * @return NiftyUpdateRouterNetworkInterfaces処理結果
	 */
	public NiftyUpdateRouterNetworkInterfacesResult niftyUpdateRouterNetworkInterfaces(NiftyUpdateRouterNetworkInterfacesRequest request);

	/**
	 * 指定したルーターを最新のバージョンにします。
	 *
	 * @param request NiftyReplaceRouterLatestVersionリクエスト
	 * @return NiftyReplaceRouterLatestVersion処理結果
	 */
	public NiftyReplaceRouterLatestVersionResult niftyReplaceRouterLatestVersion(NiftyReplaceRouterLatestVersionRequest request);

	/**
	 * 指定したルーターの旧バージョンへの復元を実施します。
	 *
	 * @param request NiftyRestoreRouterPreviousVersionリクエスト
	 * @return NiftyRestoreRouterPreviousVersion処理結果
	 */
	public NiftyRestoreRouterPreviousVersionResult niftyRestoreRouterPreviousVersion(NiftyRestoreRouterPreviousVersionRequest request);

	/**
	 * 指定したルーターのバックアップ状態を解除します。
	 *
	 * @param request NiftyReleaseRouterBackupStateリクエスト
	 * @return NiftyReleaseRouterBackupState処理結果
	 */
	public NiftyReleaseRouterBackupStateResult niftyReleaseRouterBackupState(NiftyReleaseRouterBackupStateRequest request);
}