/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * Webプロキシオプション情報クラス。<br />
 * このクラスはWebプロキシオプション情報を格納します。
 *
 */
public class WebProxyOption {

	/** DNSサーバのアドレス(IPv4) */
	private String nameServer;

	/**
	 * DNSサーバのアドレス(IPv4)を取得します。
	 *
	 * @return DNSサーバのアドレス(IPv4)
	 */
	@Query(name="NameServer")
	public String getNameServer() {
		return nameServer;
	}

	/**
	 * DNSサーバのアドレス(IPv4)を設定します。
	 *
	 * @param nameServer DNSサーバのアドレス(IPv4)
	 */
	public void setNameServer(String nameServer) {
		this.nameServer = nameServer;
	}

	/**
	 * DNSサーバのアドレス(IPv4)を設定し、自オブジェクトを返します。
	 *
	 * @param nameServer DNSサーバのアドレス(IPv4)
	 * @return 自オブジェクト
	 */
	public WebProxyOption withNameServer(String nameServer) {
		setNameServer(nameServer);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[nameServer=");
		builder.append(nameServer);
		builder.append("]");
		return builder.toString();
	}
}
