/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy.model;

/**
 * Webプロキシ情報クラス。<br />
 * このクラスはWebプロキシ情報を格納します。
 *
 */
public class WebProxy {

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/** Webプロキシの受け側情報 */
	private NetworkInterface listenInterface;

	/** Webプロキシポート */
	private String listenPort;

	/** Webプロキシの迂回先情報 */
	private NetworkInterface bypassInterface;

	/** DNSサーバオプション情報 */
	private WebProxyOption option;

	/** メモ */
	private String description;

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public WebProxy withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public WebProxy withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * Webプロキシの受け側情報を取得します。
	 *
	 * @return Webプロキシの受け側情報
	 */
	public NetworkInterface getListenInterface() {
		return listenInterface;
	}

	/**
	 * Webプロキシの受け側情報を設定します。
	 *
	 * @param listenInterface Webプロキシの受け側情報
	 */
	public void setListenInterface(NetworkInterface listenInterface) {
		this.listenInterface = listenInterface;
	}

	/**
	 * Webプロキシの受け側情報を設定し、自オブジェクトを返します。
	 *
	 * @param listenInterface Webプロキシの受け側情報
	 * @return 自オブジェクト
	 */
	public WebProxy withListenInterface(NetworkInterface listenInterface) {
		setListenInterface(listenInterface);
		return this;
	}

	/**
	 * Webプロキシポートを取得します。
	 *
	 * @return Webプロキシポート
	 */
	public String getListenPort() {
		return listenPort;
	}

	/**
	 * Webプロキシポートを設定します。
	 *
	 * @param listenPort Webプロキシポート
	 */
	public void setListenPort(String listenPort) {
		this.listenPort = listenPort;
	}

	/**
	 * Webプロキシポートを設定し、自オブジェクトを返します。
	 *
	 * @param listenPort Webプロキシポート
	 * @return 自オブジェクト
	 */
	public WebProxy withListenPort(String listenPort) {
		setListenPort(listenPort);
		return this;
	}

	/**
	 * Webプロキシの迂回先情報を取得します。
	 *
	 * @return Webプロキシの迂回先情報
	 */
	public NetworkInterface getBypassInterface() {
		return bypassInterface;
	}

	/**
	 * Webプロキシの迂回先情報を設定します。
	 *
	 * @param bypassInterface Webプロキシの迂回先情報
	 */
	public void setBypassInterface(NetworkInterface bypassInterface) {
		this.bypassInterface = bypassInterface;
	}

	/**
	 * Webプロキシの迂回先情報を設定し、自オブジェクトを返します。
	 *
	 * @param bypassInterface Webプロキシの迂回先情報
	 * @return 自オブジェクト
	 */
	public WebProxy withBypassInterface(NetworkInterface bypassInterface) {
		setBypassInterface(bypassInterface);
		return this;
	}

	/**
	 * DNSサーバオプション情報を取得します。
	 *
	 * @return DNSサーバオプション情報
	 */
	public WebProxyOption getOption() {
		return option;
	}

	/**
	 * DNSサーバオプション情報を設定します。
	 *
	 * @param option DNSサーバオプション情報
	 */
	public void setOption(WebProxyOption option) {
		this.option = option;
	}

	/**
	 * DNSサーバオプション情報を設定し、自オブジェクトを返します。
	 *
	 * @param option DNSサーバオプション情報
	 * @return 自オブジェクト
	 */
	public WebProxy withOption(WebProxyOption option) {
		setOption(option);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public WebProxy withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", listenInterface=");
		builder.append(listenInterface);
		builder.append(", listenPort=");
		builder.append(listenPort);
		builder.append(", bypassInterface=");
		builder.append(bypassInterface);
		builder.append(", option=");
		builder.append(option);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
