/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyWebProxyAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyWebProxyAttributeへのリクエストを構築します。
 *
 */
@Action("NiftyModifyWebProxyAttribute")
public class NiftyModifyWebProxyAttributeRequest implements Request {

	/** ルーターユニークID */
	private String routerId;

	/** ルータ－名 */
	private String routerName;

	/** 更新対象の項目名 */
	private String attribute;

	/** 更新値 */
	private String value;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyModifyWebProxyAttributeRequest withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルータ－名を取得します。
	 *
	 * @return ルータ－名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルータ－名を設定します。
	 *
	 * @param routerName ルータ－名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルータ－名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルータ－名
	 * @return 自オブジェクト
	 */
	public NiftyModifyWebProxyAttributeRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * 更新対象の項目名を取得します。
	 *
	 * @return 更新対象の項目名
	 */
	@Query(name="Attribute")
	public String getAttribute() {
		return attribute;
	}

	/**
	 * 更新対象の項目名を設定します。
	 *
	 * @param attribute 更新対象の項目名
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	/**
	 * 更新対象の項目名を設定し、自オブジェクトを返します。
	 *
	 * @param attribute 更新対象の項目名
	 * @return 自オブジェクト
	 */
	public NiftyModifyWebProxyAttributeRequest withAttribute(String attribute) {
		setAttribute(attribute);
		return this;
	}

	/**
	 * 更新値を取得します。
	 *
	 * @return 更新値
	 */
	@Query(name="Value")
	public String getValue() {
		return value;
	}

	/**
	 * 更新値を設定します。
	 *
	 * @param value 更新値
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * 更新値を設定し、自オブジェクトを返します。
	 *
	 * @param value 更新値
	 * @return 自オブジェクト
	 */
	public NiftyModifyWebProxyAttributeRequest withValue(String value) {
		setValue(value);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyModifyWebProxyAttributeRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", attribute=");
		builder.append(attribute);
		builder.append(", value=");
		builder.append(value);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
