/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreateWebProxyリクエストクラス。<br />
 * このクラスはNiftyCreateWebProxyへのリクエストを構築します。
 *
 */
@Action("NiftyCreateWebProxy")
public class NiftyCreateWebProxyRequest implements Request {

	/** ルーターユニークID */
	private String routerId;

	/** ルータ－名 */
	private String routerName;

	/** Webプロキシの受け側ネットワーク情報 */
	private NetworkInterface listenInterface;

	/** Webプロキシポート */
	private String listenPort;

	/** Webプロキシの迂回先ネットワーク情報 */
	private NetworkInterface bypassInterface;

	/** DNSサーバオプション情報 */
	private WebProxyOption option;

	/** メモ */
	private String description;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyCreateWebProxyRequest() {
	}

	/**
	 * Webプロキシの受け側ネットワーク情報,Webプロキシポートを指定し、NiftyCreateWebProxyRequestを構築します。
	 *
	 * @param listenInterface Webプロキシの受け側ネットワーク情報
	 * @param listenPort Webプロキシポート
	 */
	public NiftyCreateWebProxyRequest(NetworkInterface listenInterface, String listenPort) {
		this.listenInterface = listenInterface;
		this.listenPort = listenPort;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルータ－名を取得します。
	 *
	 * @return ルータ－名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルータ－名を設定します。
	 *
	 * @param routerName ルータ－名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルータ－名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルータ－名
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * Webプロキシの受け側ネットワーク情報を取得します。
	 *
	 * @return Webプロキシの受け側ネットワーク情報
	 */
	@Query(name="ListenInterface", require=true)
	public NetworkInterface getListenInterface() {
		return listenInterface;
	}

	/**
	 * Webプロキシの受け側ネットワーク情報を設定します。
	 *
	 * @param listenInterface Webプロキシの受け側ネットワーク情報
	 */
	public void setListenInterface(NetworkInterface listenInterface) {
		this.listenInterface = listenInterface;
	}

	/**
	 * Webプロキシの受け側ネットワーク情報を設定し、自オブジェクトを返します。
	 *
	 * @param listenInterface Webプロキシの受け側ネットワーク情報
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withListenInterface(NetworkInterface listenInterface) {
		setListenInterface(listenInterface);
		return this;
	}

	/**
	 * Webプロキシポートを取得します。
	 *
	 * @return Webプロキシポート
	 */
	@Query(name="ListenPort", require=true)
	public String getListenPort() {
		return listenPort;
	}

	/**
	 * Webプロキシポートを設定します。
	 *
	 * @param listenPort Webプロキシポート
	 */
	public void setListenPort(String listenPort) {
		this.listenPort = listenPort;
	}

	/**
	 * Webプロキシポートを設定し、自オブジェクトを返します。
	 *
	 * @param listenPort Webプロキシポート
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withListenPort(String listenPort) {
		setListenPort(listenPort);
		return this;
	}

	/**
	 * Webプロキシの迂回先ネットワーク情報を取得します。
	 *
	 * @return Webプロキシの迂回先ネットワーク情報
	 */
	@Query(name="BypassInterface")
	public NetworkInterface getBypassInterface() {
		return bypassInterface;
	}

	/**
	 * Webプロキシの迂回先ネットワーク情報を設定します。
	 *
	 * @param bypassInterface Webプロキシの迂回先ネットワーク情報
	 */
	public void setBypassInterface(NetworkInterface bypassInterface) {
		this.bypassInterface = bypassInterface;
	}

	/**
	 * Webプロキシの迂回先ネットワーク情報を設定し、自オブジェクトを返します。
	 *
	 * @param bypassInterface Webプロキシの迂回先ネットワーク情報
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withBypassInterface(NetworkInterface bypassInterface) {
		setBypassInterface(bypassInterface);
		return this;
	}

	/**
	 * DNSサーバオプション情報を取得します。
	 *
	 * @return DNSサーバオプション情報
	 */
	@Query(name="Option")
	public WebProxyOption getOption() {
		return option;
	}

	/**
	 * DNSサーバオプション情報を設定します。
	 *
	 * @param option DNSサーバオプション情報
	 */
	public void setOption(WebProxyOption option) {
		this.option = option;
	}

	/**
	 * DNSサーバオプション情報を設定し、自オブジェクトを返します。
	 *
	 * @param option DNSサーバオプション情報
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withOption(WebProxyOption option) {
		setOption(option);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="Description")
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withDescription(String description) {
		setDescription(description);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyCreateWebProxyRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", listenInterface=");
		builder.append(listenInterface);
		builder.append(", listenPort=");
		builder.append(listenPort);
		builder.append(", bypassInterface=");
		builder.append(bypassInterface);
		builder.append(", option=");
		builder.append(option);
		builder.append(", description=");
		builder.append(description);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
