/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ネットワークインターフェイス情報クラス。<br />
 * このクラスはネットワークインターフェイス情報を格納します。
 *
 */
public class NetworkInterface {

	/** ネットワークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/**
	 * ネットワークIDを取得します。
	 *
	 * @return ネットワークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークIDを設定します。
	 *
	 * @param networkId ネットワークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークID
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param networkName ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append("]");
		return builder.toString();
	}
}
