/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.proxy.model.NiftyCreateWebProxyRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyCreateWebProxyResult;
import com.nifty.cloud.sdk.proxy.model.NiftyDeleteWebProxyRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyDeleteWebProxyResult;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesResult;
import com.nifty.cloud.sdk.proxy.model.NiftyModifyWebProxyAttributeRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyModifyWebProxyAttributeResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * プロキシカテゴリ クライアント。<br />
 * プロキシ カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftyProxyClient extends BaseClient implements NiftyProxy {

	/**
	 * 認証情報を指定し、プロキシカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyProxyClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、プロキシカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyProxyClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.proxy.NiftyProxy#niftyCreateWebProxy(com.nifty.cloud.sdk.proxy.model.NiftyCreateWebProxyRequest)
	 */
	@Override
	public NiftyCreateWebProxyResult niftyCreateWebProxy(NiftyCreateWebProxyRequest request) {
		return (NiftyCreateWebProxyResult) client.execute(request, NiftyCreateWebProxyResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.proxy.NiftyProxy#niftyDeleteWebProxy(com.nifty.cloud.sdk.proxy.model.NiftyDeleteWebProxyRequest)
	 */
	@Override
	public NiftyDeleteWebProxyResult niftyDeleteWebProxy(NiftyDeleteWebProxyRequest request) {
		return (NiftyDeleteWebProxyResult) client.execute(request, NiftyDeleteWebProxyResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.proxy.NiftyProxy#niftyDescribeWebProxies(com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesRequest)
	 */
	@Override
	public NiftyDescribeWebProxiesResult niftyDescribeWebProxies(NiftyDescribeWebProxiesRequest request) {
		return (NiftyDescribeWebProxiesResult) client.execute(request, NiftyDescribeWebProxiesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.proxy.NiftyProxy#niftyModifyWebProxyAttribute(com.nifty.cloud.sdk.proxy.model.NiftyModifyWebProxyAttributeRequest)
	 */
	@Override
	public NiftyModifyWebProxyAttributeResult niftyModifyWebProxyAttribute(NiftyModifyWebProxyAttributeRequest request) {
		return (NiftyModifyWebProxyAttributeResult) client.execute(request, NiftyModifyWebProxyAttributeResult.class);
	}
}