/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.proxy;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.proxy.model.NiftyCreateWebProxyRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyCreateWebProxyResult;
import com.nifty.cloud.sdk.proxy.model.NiftyDeleteWebProxyRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyDeleteWebProxyResult;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesResult;
import com.nifty.cloud.sdk.proxy.model.NiftyModifyWebProxyAttributeRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyModifyWebProxyAttributeResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * プロキシカテゴリクライアント。<br />
 * プロキシ カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftyProxyAsync extends NiftyProxy {

	/**
	 * 非同期で指定したルーターに対し、Webプロキシを新規作成します。
	 *
	 * @param request NiftyCreateWebProxyリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateWebProxyResult> niftyCreateWebProxyAsync(NiftyCreateWebProxyRequest request);


	/**
	 * 非同期で指定したルーターに設定されたWebプロキシを削除します。
	 *
	 * @param request NiftyDeleteWebProxyリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteWebProxyResult> niftyDeleteWebProxyAsync(NiftyDeleteWebProxyRequest request);


	/**
	 * 非同期でルーターに設定されたWebプロキシの情報を取得します。
	 *
	 * @param request NiftyDescribeWebProxiesリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeWebProxiesResult> niftyDescribeWebProxiesAsync(NiftyDescribeWebProxiesRequest request);


	/**
	 * 非同期で指定したルーターに設定されたWebプロキシの情報を更新します。
	 *
	 * @param request NiftyModifyWebProxyAttributeリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyModifyWebProxyAttributeResult> niftyModifyWebProxyAttributeAsync(NiftyModifyWebProxyAttributeRequest request);

}