/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.privatelan.model.Instance;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.PrivateLan;
import com.nifty.cloud.sdk.privatelan.model.Router;
import com.nifty.cloud.sdk.privatelan.model.Tag;
import com.nifty.cloud.sdk.privatelan.model.VpnGateway;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyCreatePrivateLanResponseInfoType変換クラス。<br />
 * このクラスはレスポンスXMLのNiftyCreatePrivateLan要素からNiftyCreatePrivateLanResultクラスのリストを生成します。
 */
public class NiftyCreatePrivateLanResultConverter implements Converter {

	private static final String ELEMENT_REQUEST_ID = "requestId";
	private static final String ELEMENT_PRIVATE_LAN = "privateLan";
	private static final String ELEMENT_NETWORK_ID = "networkId";
	private static final String ELEMENT_PRIVATE_LAN_NAME = "privateLanName";
	private static final String ELEMENT_STATE = "state";
	private static final String ELEMENT_CIDR_BLOCK = "cidrBlock";
	private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";

	private static final String ELEMENT_TAG_SET = "tagSet";
	private static final String ELEMENT_ACCOUNTING_TYPE = "accountingType";
	private static final String ELEMENT_DESCRIPTION = "description";

	private static final String ELEMENT_INSTANCES_SET = "instancesSet";
	private static final String ELEMENT_ROUTER_SET = "routerSet";
	private static final String ELEMENT_VPN_GATEWAY_SET = "vpnGatewaySet";

	private static final String ELEMENT_CREATED_TIME = "createdTime";
	private static final String ELEMENT_SHARING_STATUS = "sharingStatus";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == NiftyCreatePrivateLanResult.class;
	}

	/**
	 * {@literal
	 * NiftyCreatePrivateLanResponse要素をNiftyCreatePrivateLanResultクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal NiftyCreatePrivateLanResultオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		NiftyCreatePrivateLanResult result = new NiftyCreatePrivateLanResult();
		PrivateLan privateLan = new PrivateLan();
		result.setPrivateLan(privateLan);

		Converter tagSetConverter = new TagSetConverter();
		Converter instancesSetConverter = new InstancesSetConverter();
		Converter routerSetConverter = new RouterSetConverter();
		Converter vpnGatewaySetConverter = new VpnGatewaySetConverter();
		String name = null;

		while(reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_REQUEST_ID)) {
				result.setRequestId(reader.getValue());
			}
			if (name.equals(ELEMENT_PRIVATE_LAN)){
				while (reader.hasMoreChildren()) {
					reader.moveDown();
					name = reader.getNodeName();
					if (name.equals(ELEMENT_NETWORK_ID)) {
						privateLan.setNetworkId(reader.getValue());
					}
					else if (name.equals(ELEMENT_PRIVATE_LAN_NAME)) {
						privateLan.setPrivateLanName(reader.getValue());
					}
					else if (name.equals(ELEMENT_STATE)) {
						privateLan.setState(reader.getValue());
					}
					else if (name.equals(ELEMENT_CIDR_BLOCK)) {
						privateLan.setCidrBlock(reader.getValue());
					}
					else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
						privateLan.setAvailabilityZone(reader.getValue());
					}
					else if (name.equals(ELEMENT_TAG_SET)) {
						privateLan.setTagSets((List<Tag>) tagSetConverter.unmarshal(reader, context));
					}
					else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
						privateLan.setAccountingType(reader.getValue());
					}
					else if (name.equals(ELEMENT_DESCRIPTION)) {
						privateLan.setDescription(reader.getValue());
					}
					else if (name.equals(ELEMENT_INSTANCES_SET)) {
						privateLan.setInstanceSets((List<Instance>) instancesSetConverter.unmarshal(reader, context));
					}
					else if (name.equals(ELEMENT_ROUTER_SET)) {
						privateLan.setRouterSets((List<Router>) routerSetConverter.unmarshal(reader, context));
					}
					else if (name.equals(ELEMENT_VPN_GATEWAY_SET)) {
						privateLan.setVpnGatewaySets((List<VpnGateway>) vpnGatewaySetConverter.unmarshal(reader, context));
					}
					else if (name.equals(ELEMENT_CREATED_TIME)) {
						privateLan.setCreatedTime(reader.getValue());
					}
					else if (name.equals(ELEMENT_SHARING_STATUS)) {
						privateLan.setSharingStatus(reader.getValue());
					}
					reader.moveUp();
				}
			}
			reader.moveUp();
		}
		return result;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
