/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

/**
 * VpnGatewayクラス。<br />
 * このクラスはVpnGateway情報を格納します。
 */
public class VpnGateway {

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** デバイス番号 */
	private Integer deviceIndex;

	/** IPアドレス */
	private String ipAddress;

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 * @return VPNゲートウェイユニークID
	 */
	public String getVpnGatewayId() {
	    return vpnGatewayId;
	}
	/**
	 * VPNゲートウェイユニークIDを設定します。
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
	    this.vpnGatewayId = vpnGatewayId;
	}
	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public VpnGateway withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyVpnGatewayName() {
	    return niftyVpnGatewayName;
	}
	/**
	 * VPNゲートウェイ名を設定します。
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
	    this.niftyVpnGatewayName = niftyVpnGatewayName;
	}
	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public VpnGateway withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * デバイス番号を取得します。
	 * @return デバイス番号
	 */
	public Integer getDeviceIndex() {
	    return deviceIndex;
	}
	/**
	 * デバイス番号を設定します。
	 * @param deviceIndex デバイス番号
	 */
	public void setDeviceIndex(Integer deviceIndex) {
	    this.deviceIndex = deviceIndex;
	}
	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex デバイス番号
	 * @return 自オブジェクト
	 */
	public VpnGateway withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 * @return IPアドレス
	 */
	public String getIpAddress() {
	    return ipAddress;
	}
	/**
	 * IPアドレスを設定します。
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
	    this.ipAddress = ipAddress;
	}
	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public VpnGateway withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
